/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.util.function.BiConsumer;
import net.reini.rabbitmq.cdi.ConnectionConfig;
import net.reini.rabbitmq.cdi.EncodeException;
import net.reini.rabbitmq.cdi.Encoder;
import net.reini.rabbitmq.cdi.PublishException;

final class PublisherConfiguration
implements BiConsumer<Object, PublishException> {
    private final ConnectionConfig config;
    private final AMQP.BasicProperties basicProperties;
    private final Encoder<?> messageEncoder;
    private final String exchange;
    private final String routingKey;
    private final BiConsumer<?, PublishException> errorHandler;

    PublisherConfiguration(ConnectionConfig config, String exchange, String routingKey, AMQP.BasicProperties.Builder basicPropertiesBuilder, Encoder<?> encoder, BiConsumer<?, PublishException> errorHandler) {
        this.config = config;
        this.exchange = exchange;
        this.routingKey = routingKey;
        this.messageEncoder = encoder;
        this.errorHandler = errorHandler;
        String contentType = this.messageEncoder.contentType();
        if (contentType != null) {
            basicPropertiesBuilder.contentType(contentType);
        }
        this.basicProperties = basicPropertiesBuilder.build();
    }

    ConnectionConfig getConfig() {
        return this.config;
    }

    public String toString() {
        return this.config.toString();
    }

    void publish(Channel channel, Object event) throws EncodeException, IOException {
        byte[] data = this.messageEncoder.encode(event);
        channel.basicPublish(this.exchange, this.routingKey, this.basicProperties, data);
    }

    @Override
    public void accept(Object event, PublishException publishError) {
        BiConsumer<?, PublishException> consumer = this.errorHandler;
        consumer.accept(event, publishError);
    }
}

