/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.reini.rabbitmq.cdi.ConnectionProducer;
import net.reini.rabbitmq.cdi.GenericPublisher;
import net.reini.rabbitmq.cdi.MessagePublisher;
import net.reini.rabbitmq.cdi.PublishException;
import net.reini.rabbitmq.cdi.PublisherConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EventPublisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventPublisher.class);
    private final ConnectionProducer connectionProducer;
    private final Map<Class<?>, Set<PublisherConfiguration>> publisherConfigurations;
    private final ThreadLocal<Map<Class<?>, MessagePublisher>> publishers;

    @Inject
    public EventPublisher(ConnectionProducer connectionProducer) {
        this.connectionProducer = connectionProducer;
        this.publisherConfigurations = new HashMap();
        this.publishers = ThreadLocal.withInitial(HashMap::new);
    }

    public void addEvent(Class<?> eventType, PublisherConfiguration configuration) {
        this.publisherConfigurations.computeIfAbsent(eventType, key -> new HashSet()).add(configuration);
    }

    public void publishEvent(@Observes Object event) {
        Class<?> eventType = event.getClass();
        Set<PublisherConfiguration> configurations = this.publisherConfigurations.get(eventType);
        if (configurations == null) {
            LOGGER.trace("No publisher configured for event {}", event);
        } else {
            configurations.forEach(config -> this.doPublish(event, this.providePublisher(eventType), (PublisherConfiguration)config));
        }
    }

    @PreDestroy
    public void cleanUp() {
        this.publishers.get().values().forEach(MessagePublisher::close);
    }

    void doPublish(Object event, MessagePublisher publisher, PublisherConfiguration configuration) {
        try {
            LOGGER.debug("Start publishing event {} ({})...", event, (Object)configuration);
            publisher.publish(event, configuration);
            LOGGER.debug("Published event successfully");
        }
        catch (PublishException e) {
            LOGGER.debug("Published event failed");
            configuration.accept(event, e);
        }
    }

    MessagePublisher providePublisher(Class<?> eventType) {
        return this.publishers.get().computeIfAbsent(eventType, key -> new GenericPublisher(this.connectionProducer));
    }
}

