/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import net.reini.rabbitmq.cdi.DecodeException;
import net.reini.rabbitmq.cdi.Decoder;
import net.reini.rabbitmq.cdi.EnvelopeConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventConsumer
implements EnvelopeConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventConsumer.class);
    private final Decoder<?> decoder;
    private final Event<Object> eventControl;
    private final Instance<Object> eventPool;

    EventConsumer(Decoder<?> decoder, Event<Object> eventControl, Instance<Object> eventPool) {
        this.decoder = decoder;
        this.eventControl = eventControl;
        this.eventPool = eventPool;
    }

    Object buildEvent(byte[] messageBody) {
        Object event;
        try {
            event = this.decoder.decode(messageBody);
        }
        catch (DecodeException e) {
            LOGGER.error("Unable to read decode event from message: ".concat(new String(messageBody)), (Throwable)e);
            event = this.eventPool.get();
        }
        return event;
    }

    @Override
    public boolean consume(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
        long deliveryTag = envelope.getDeliveryTag();
        LOGGER.debug("Handle delivery: consumerTag: {}, deliveryTag: {}", (Object)consumerTag, (Object)deliveryTag);
        String contentType = properties.getContentType();
        if (this.decoder.willDecode(contentType)) {
            Object event = this.buildEvent(body);
            this.eventControl.fire(event);
            return true;
        }
        LOGGER.error("Unable to process unknown message content type: {}", (Object)contentType);
        return false;
    }
}

