/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Address;
import com.rabbitmq.client.MessageProperties;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import net.reini.rabbitmq.cdi.ConnectionConfigHolder;
import net.reini.rabbitmq.cdi.ConnectionConfiguration;
import net.reini.rabbitmq.cdi.ConnectionProducer;
import net.reini.rabbitmq.cdi.ConsumerContainer;
import net.reini.rabbitmq.cdi.Decoder;
import net.reini.rabbitmq.cdi.Encoder;
import net.reini.rabbitmq.cdi.EventConsumer;
import net.reini.rabbitmq.cdi.EventPublisher;
import net.reini.rabbitmq.cdi.JsonDecoder;
import net.reini.rabbitmq.cdi.JsonEncoder;
import net.reini.rabbitmq.cdi.PublishException;
import net.reini.rabbitmq.cdi.PublisherConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public abstract class EventBinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventBinder.class);
    private final Set<QueueBinding<?>> queueBindings;
    private final Set<ExchangeBinding<?>> exchangeBindings = new HashSet();
    @Inject
    private Event<Object> remoteEventControl;
    @Inject
    private Instance<Object> remoteEventPool;
    @Inject
    private EventPublisher eventPublisher;
    @Inject
    private ConnectionProducer connectionProducer;
    private ConnectionConfiguration configuration;
    private ConsumerContainer consumerContainer;

    public EventBinder() {
        this.queueBindings = new HashSet();
    }

    protected abstract void bindEvents();

    public BinderConfiguration configuration() {
        return new BinderConfiguration(this.configuration);
    }

    public void initialize() throws IOException {
        this.bindEvents();
        this.processQueueBindings();
        this.consumerContainer.startAllConsumers();
        this.processExchangeBindings();
    }

    @PostConstruct
    void initializeConsumerContainer() {
        this.configuration = new ConnectionConfiguration();
        this.consumerContainer = new ConsumerContainer(this.configuration, this.connectionProducer);
    }

    void processExchangeBindings() {
        this.exchangeBindings.forEach(this::bindExchange);
        this.exchangeBindings.clear();
    }

    void processQueueBindings() {
        this.queueBindings.forEach(this::bindQueue);
        this.queueBindings.clear();
    }

    void bindQueue(QueueBinding<?> queueBinding) {
        Class<?> eventType = queueBinding.getEventType();
        Event eventControl = this.remoteEventControl.select(eventType, new Annotation[0]);
        Instance eventPool = this.remoteEventPool.select(eventType, new Annotation[0]);
        EventConsumer consumer = new EventConsumer(queueBinding.getDecoder(), (Event<Object>)eventControl, (Instance<Object>)eventPool);
        String queue = queueBinding.getQueue();
        this.consumerContainer.addConsumer(consumer, queue, queueBinding.isAutoAck());
        LOGGER.info("Binding between queue {} and event type {} activated", (Object)queue, (Object)eventType.getName());
    }

    void bindExchange(ExchangeBinding<?> exchangeBinding) {
        Class<?> eventType = exchangeBinding.getEventType();
        String exchange = exchangeBinding.getExchange();
        PublisherConfiguration cfg = new PublisherConfiguration(this.configuration, exchange, exchangeBinding.getRoutingKey(), exchangeBinding.getBasicPropertiesBuilder(), exchangeBinding.getEncoder(), exchangeBinding.getErrorHandler());
        this.eventPublisher.addEvent(eventType, cfg);
        LOGGER.info("Binding between exchange {} and event type {} activated", (Object)exchange, (Object)eventType.getName());
    }

    static <T> BiConsumer<T, PublishException> nop() {
        return (event, cause) -> {};
    }

    static String uriDecode(String value) {
        try {
            return URLDecoder.decode(value.replace("+", "%2B"), "US-ASCII");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public <M> EventBindingBuilder<M> bind(Class<M> event) {
        return new EventBindingBuilder<M>(event, this.queueBindings::add, this.exchangeBindings::add);
    }

    public static final class BinderConfiguration {
        private final ConnectionConfigHolder config;

        BinderConfiguration(ConnectionConfigHolder config) {
            this.config = config;
        }

        @Deprecated
        public BinderConfiguration setHost(String hostName) {
            return this.addHost(Address.parseAddress((String)hostName));
        }

        public BinderConfiguration addHost(String hostName) {
            return this.addHost(Address.parseAddress((String)hostName));
        }

        public BinderConfiguration addHost(Address hostAddress) {
            this.config.addHost(hostAddress);
            return this;
        }

        public BinderConfiguration setUsername(String username) {
            this.config.setUsername(username);
            return this;
        }

        public BinderConfiguration setPassword(String password) {
            this.config.setPassword(password);
            return this;
        }

        public BinderConfiguration setVirtualHost(String virtualHost) {
            this.config.setVirtualHost(virtualHost);
            return this;
        }

        public BinderConfiguration setSecure(boolean secure) {
            this.config.setSecure(secure);
            return this;
        }

        public BinderConfiguration setConnectionUri(URI uri) {
            String path;
            String host;
            int port = uri.getPort();
            String scheme = uri.getScheme().toLowerCase();
            if ("amqp".equals(scheme)) {
                if (port == -1) {
                    port = 5672;
                }
            } else if ("amqps".equals(scheme)) {
                this.config.setSecure(true);
                if (port == -1) {
                    port = 5671;
                }
            } else {
                throw new IllegalArgumentException("Wrong scheme in AMQP URI: " + uri.getScheme());
            }
            if ((host = uri.getHost()) == null) {
                host = "127.0.0.1";
            }
            this.config.setHosts(Collections.singleton(new Address(host, port)));
            String userInfo = uri.getRawUserInfo();
            if (userInfo != null) {
                String[] userPass = userInfo.split(":");
                if (userPass.length > 2) {
                    throw new IllegalArgumentException("Bad user info in AMQP URI: " + userInfo);
                }
                this.setUsername(EventBinder.uriDecode(userPass[0]));
                if (userPass.length == 2) {
                    this.setPassword(EventBinder.uriDecode(userPass[1]));
                }
            }
            if ((path = uri.getRawPath()) != null && path.length() > 0) {
                if (path.indexOf(47, 1) != -1) {
                    throw new IllegalArgumentException("Multiple segments in path of AMQP URI: " + path);
                }
                this.setVirtualHost(EventBinder.uriDecode(path.substring(1)));
            }
            return this;
        }
    }

    public static final class ExchangeBinding<T> {
        private final Class<T> eventType;
        private final String exchange;
        private final Map<String, Object> headers;
        private String routingKey;
        private Encoder<T> encoder;
        private AMQP.BasicProperties.Builder basicPropertiesBuilder;
        private BiConsumer<T, PublishException> errorHandler;

        ExchangeBinding(Class<T> eventType, String exchange) {
            this.eventType = eventType;
            this.exchange = exchange;
            this.headers = new HashMap<String, Object>();
            this.encoder = new JsonEncoder();
            this.routingKey = "";
            this.errorHandler = EventBinder.nop();
            this.basicPropertiesBuilder = MessageProperties.BASIC.builder().headers(this.headers);
            LOGGER.info("Binding created between exchange {} and event type {}", (Object)exchange, (Object)eventType.getSimpleName());
        }

        Class<T> getEventType() {
            return this.eventType;
        }

        String getExchange() {
            return this.exchange;
        }

        String getRoutingKey() {
            return this.routingKey;
        }

        Encoder<T> getEncoder() {
            return this.encoder;
        }

        BiConsumer<T, PublishException> getErrorHandler() {
            return this.errorHandler;
        }

        AMQP.BasicProperties.Builder getBasicPropertiesBuilder() {
            return this.basicPropertiesBuilder;
        }

        public ExchangeBinding<T> withRoutingKey(String key) {
            this.routingKey = Objects.requireNonNull(key, "key must not be null");
            LOGGER.info("Routing key for event type {} set to {}", (Object)this.eventType.getSimpleName(), (Object)key);
            return this;
        }

        public ExchangeBinding<T> withEncoder(Encoder<T> messageEncoder) {
            this.encoder = Objects.requireNonNull(messageEncoder, "encoder must not be null");
            LOGGER.info("Encoder for event type {} set to {}", (Object)this.eventType.getSimpleName(), (Object)this.encoder.getClass().getName());
            return this;
        }

        public ExchangeBinding<T> withHeader(String header, Object headerValue) {
            this.headers.put(Objects.requireNonNull(header, "header must not be null"), Objects.requireNonNull(headerValue, "headerValue must not be null"));
            return this;
        }

        public ExchangeBinding<T> withProperties(AMQP.BasicProperties properties) {
            this.basicPropertiesBuilder = Objects.requireNonNull(properties, "propeties must not be null").builder().headers(this.headers);
            LOGGER.info("Publisher properties for event type {} set to {}", (Object)this.eventType.getSimpleName(), (Object)properties.toString());
            this.headers.clear();
            Map newHeaders = properties.getHeaders();
            if (newHeaders != null) {
                this.headers.putAll(newHeaders);
            }
            return this;
        }

        public ExchangeBinding<T> withErrorHandler(BiConsumer<T, PublishException> handler) {
            this.errorHandler = handler == null ? EventBinder.nop() : handler;
            return this;
        }

        public int hashCode() {
            return Objects.hash(this.eventType, this.exchange);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExchangeBinding)) {
                return false;
            }
            ExchangeBinding other = (ExchangeBinding)obj;
            return this.eventType.equals(other.eventType) && this.exchange.equals(other.exchange);
        }

        public String toString() {
            return String.format("ExchangeBinding[type=%s, exchange=%s]", this.eventType.getName(), this.exchange);
        }
    }

    public static final class QueueBinding<T> {
        private final Class<T> eventType;
        private final String queue;
        private boolean autoAck;
        private Decoder<T> decoder;

        QueueBinding(Class<T> eventType, String queue) {
            this.eventType = eventType;
            this.queue = queue;
            this.decoder = new JsonDecoder<T>(eventType);
            LOGGER.info("Binding created between queue {} and event type {}", (Object)queue, (Object)eventType.getSimpleName());
        }

        Class<T> getEventType() {
            return this.eventType;
        }

        String getQueue() {
            return this.queue;
        }

        boolean isAutoAck() {
            return this.autoAck;
        }

        Decoder<T> getDecoder() {
            return this.decoder;
        }

        public QueueBinding<T> autoAck() {
            this.autoAck = true;
            LOGGER.info("Auto acknowledges enabled for event type {}", (Object)this.eventType.getSimpleName());
            return this;
        }

        public QueueBinding<T> withDecoder(Decoder<T> messageDecoder) {
            this.decoder = Objects.requireNonNull(messageDecoder, "decoder must not be null");
            LOGGER.info("Decoder set to {} for event type {}", messageDecoder, (Object)this.eventType.getSimpleName());
            return this;
        }

        public int hashCode() {
            return Objects.hash(this.eventType, this.queue);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof QueueBinding)) {
                return false;
            }
            QueueBinding other = (QueueBinding)obj;
            return this.eventType.equals(other.eventType) && this.queue.equals(other.queue);
        }

        public String toString() {
            return String.format("QueueBinding[type=%s, queue=%s]", this.eventType.getName(), this.queue);
        }
    }

    public static final class EventBindingBuilder<T> {
        private final Class<T> eventType;
        private final Consumer<QueueBinding<T>> queueBindingConsumer;
        private final Consumer<ExchangeBinding<T>> exchangeBindingConsumer;

        EventBindingBuilder(Class<T> eventType, Consumer<QueueBinding<T>> queueBindingConsumer, Consumer<ExchangeBinding<T>> exchangeBindingConsumer) {
            this.eventType = eventType;
            this.queueBindingConsumer = queueBindingConsumer;
            this.exchangeBindingConsumer = exchangeBindingConsumer;
        }

        public QueueBinding<T> toQueue(String queue) {
            QueueBinding<T> queueBinding = new QueueBinding<T>(this.eventType, queue);
            this.queueBindingConsumer.accept(queueBinding);
            return queueBinding;
        }

        public ExchangeBinding<T> toExchange(String exchange) {
            ExchangeBinding<T> exchangeBinding = new ExchangeBinding<T>(this.eventType, exchange);
            this.exchangeBindingConsumer.accept(exchangeBinding);
            return exchangeBinding;
        }
    }
}

