/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.reini.rabbitmq.cdi.ConnectionConfig;
import net.reini.rabbitmq.cdi.ConnectionListener;
import net.reini.rabbitmq.cdi.ConnectionProducer;
import net.reini.rabbitmq.cdi.ConsumerImpl;
import net.reini.rabbitmq.cdi.EventConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConsumerContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsumerContainer.class);
    private final ConnectionConfig config;
    private final ConnectionProducer connectionProducer;
    private final CopyOnWriteArrayList<ConsumerHolder> consumerHolders;

    ConsumerContainer(ConnectionConfig config, ConnectionProducer connectionProducer) {
        this.config = config;
        this.connectionProducer = connectionProducer;
        this.consumerHolders = new CopyOnWriteArrayList();
    }

    protected Channel createChannel() throws IOException, TimeoutException, NoSuchAlgorithmException {
        LOGGER.debug("Creating channel");
        Channel channel = this.connectionProducer.getConnection(this.config).createChannel();
        LOGGER.debug("Created channel");
        return channel;
    }

    public void addConsumer(EventConsumer consumer, String queue, boolean autoAck) {
        this.consumerHolders.add(new ConsumerHolder(consumer, queue, autoAck));
    }

    public void startAllConsumers() {
        this.connectionProducer.registerConnectionListener(this.config, new ContainerConnectionListener());
        this.consumerHolders.forEach(ConsumerHolder::activate);
    }

    final class ConsumerHolder {
        private final boolean autoAck;
        private final String queueName;
        private final AtomicBoolean active;
        private final EventConsumer consumer;
        private Channel channel;

        ConsumerHolder(EventConsumer consumer, String queueName, boolean autoAck) {
            this.consumer = consumer;
            this.queueName = queueName;
            this.autoAck = autoAck;
            this.active = new AtomicBoolean();
        }

        void deactivate() {
            if (this.active.compareAndSet(true, false)) {
                LOGGER.debug("Deactivating consumer of class {}", this.consumer.getClass());
                if (this.channel != null) {
                    try {
                        LOGGER.debug("Closing channel for consumer of class {}", this.consumer.getClass());
                        this.channel.close();
                        LOGGER.debug("Closed channel for consumer of class {}", this.consumer.getClass());
                    }
                    catch (Exception e) {
                        LOGGER.info("Aborted closing channel for consumer of class {} (already closing)", this.consumer.getClass());
                    }
                    this.channel = null;
                }
                LOGGER.info("Deactivated consumer of class {}", this.consumer.getClass());
            }
        }

        void activate() {
            if (this.active.compareAndSet(false, true)) {
                LOGGER.debug("Activating consumer of class {}", this.consumer.getClass());
                try {
                    this.channel = ConsumerContainer.this.createChannel();
                    this.channel.basicConsume(this.queueName, this.autoAck, this.autoAck ? ConsumerImpl.create(this.consumer) : ConsumerImpl.createAcknowledged(this.consumer, this.channel));
                    LOGGER.info("Activated consumer of class {}", this.consumer.getClass());
                }
                catch (IOException | NoSuchAlgorithmException | TimeoutException e) {
                    LOGGER.error("Failed to activate consumer of class {}", this.consumer.getClass(), (Object)e);
                }
            }
        }
    }

    final class ContainerConnectionListener
    implements ConnectionListener {
        ContainerConnectionListener() {
        }

        @Override
        public void onConnectionEstablished(Connection con) {
            LOGGER.info("Connection established to {}. Activating consumers...", (Object)con);
            ConsumerContainer.this.consumerHolders.forEach(consumer -> consumer.activate());
        }

        @Override
        public void onConnectionLost(Connection con) {
            LOGGER.warn("Connection lost. Deactivating consumers");
            ConsumerContainer.this.consumerHolders.forEach(consumer -> consumer.deactivate());
        }

        @Override
        public void onConnectionClosed(Connection con) {
            LOGGER.warn("Connection closed for ever. Deactivating consumers");
            ConsumerContainer.this.consumerHolders.forEach(consumer -> consumer.deactivate());
        }
    }
}

