/*
 * Decompiled with CFR 0.152.
 */
package net.reini.rabbitmq.cdi;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import net.reini.rabbitmq.cdi.ConnectionConfig;
import net.reini.rabbitmq.cdi.ConnectionConfigHolder;

class ConnectionConfiguration
implements ConnectionConfig,
ConnectionConfigHolder {
    private final List<Address> brokerHosts = new ArrayList<Address>();
    private boolean secure;
    private String username = "guest";
    private String password = "guest";
    private String virtualHost;

    ConnectionConfiguration() {
    }

    @Override
    public void setUsername(String username) {
        this.username = username == null ? "guest" : username;
    }

    @Override
    public void setPassword(String password) {
        this.password = password == null ? "guest" : password;
    }

    @Override
    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public void addHost(Address hostAddress) {
        this.brokerHosts.add(hostAddress);
    }

    @Override
    public void setHosts(Set<Address> hosts) {
        this.brokerHosts.clear();
        this.brokerHosts.addAll(hosts);
    }

    @Override
    public Connection createConnection(ConnectionFactory connectionFactory) throws IOException, TimeoutException, NoSuchAlgorithmException {
        connectionFactory.setUsername(this.username);
        connectionFactory.setPassword(this.password);
        if (this.secure) {
            SSLContext sslContext = SSLContext.getDefault();
            connectionFactory.setSslContextFactory(name -> sslContext);
        }
        if (this.virtualHost != null) {
            connectionFactory.setVirtualHost(this.virtualHost);
        }
        if (this.brokerHosts.isEmpty()) {
            throw new IllegalArgumentException("No broker host defined");
        }
        return connectionFactory.newConnection(new ArrayList<Address>(this.brokerHosts));
    }

    public String toString() {
        return String.format("broker hosts: %s, connect user: %s", this.brokerHosts, this.username);
    }

    public int hashCode() {
        return this.brokerHosts.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConnectionConfiguration)) {
            return false;
        }
        ConnectionConfiguration other = (ConnectionConfiguration)obj;
        return this.secure == other.secure && this.brokerHosts.equals(other.brokerHosts) && this.username.equals(other.username) && this.password.equals(other.password) && Objects.equals(this.virtualHost, other.virtualHost);
    }
}

