/*
 * Decompiled with CFR 0.152.
 */
package net.reini.junit;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public abstract class RecursiveTestSuiteBuilder {
    private static TestClassFilter _filter;

    public static FilenameFilter getFilenameFilter() {
        if (_filter == null) {
            _filter = new TestClassFilter();
        }
        return _filter;
    }

    public static void build(Class<?>[] classInPackages, TestSuite rootSuite) throws Exception {
        for (Class<?> classInPackage : classInPackages) {
            RecursiveTestSuiteBuilder.build(classInPackage, rootSuite);
        }
    }

    public static void build(Class<?> classInPackage, TestSuite rootSuite) throws Exception {
        String testSuiteClassName = classInPackage.getName();
        File suiteFile = new File(classInPackage.getClassLoader().getResource(testSuiteClassName.replace('.', '/').concat(".class")).getFile());
        Package basePackage = classInPackage.getPackage();
        String basePackageName = basePackage == null ? "" : basePackage.getName();
        File baseDir = suiteFile.getParentFile();
        String suiteName = basePackageName.isEmpty() ? "[default package]" : basePackageName;
        TestSuite suite = new TestSuite(suiteName);
        rootSuite.addTest((Test)suite);
        RecursiveTestSuiteBuilder.build(baseDir.getAbsolutePath().length(), basePackageName, baseDir, RecursiveTestSuiteBuilder.getFilenameFilter(), suite);
    }

    public static void build(int prefixLength, String basePackage, File currentDir, FilenameFilter filter, TestSuite rootSuite) throws Exception {
        List<File> potentialDirectories = Arrays.asList(currentDir.listFiles(filter));
        if (!potentialDirectories.isEmpty()) {
            StringBuilder currentPackageName = new StringBuilder(200);
            currentPackageName.append(basePackage);
            String absolutePath = currentDir.getAbsolutePath();
            int startIndex = prefixLength;
            if (basePackage.isEmpty() && absolutePath.length() > prefixLength) {
                startIndex = prefixLength + 1;
            }
            String replaced = absolutePath.substring(startIndex).replaceAll("[\\\\|/]", ".");
            currentPackageName.append(replaced);
            ArrayList<File> classFiles = new ArrayList<File>(potentialDirectories.size());
            Collections.sort(potentialDirectories, new FileComparator());
            for (File potentialDirectory : potentialDirectories) {
                if (potentialDirectory.isDirectory()) {
                    TestSuite subTestSuite = new TestSuite(potentialDirectory.getName());
                    RecursiveTestSuiteBuilder.build(prefixLength, basePackage, potentialDirectory, filter, subTestSuite);
                    if (subTestSuite.countTestCases() <= 0) continue;
                    rootSuite.addTest((Test)subTestSuite);
                    continue;
                }
                classFiles.add(potentialDirectory);
            }
            for (File file : classFiles) {
                String fileName = file.getName().replaceFirst(".class$", "");
                String className = currentPackageName.length() == 0 ? fileName : new StringBuilder(200).append((CharSequence)currentPackageName).append('.').append(fileName).toString();
                try {
                    Class<?> clazz = Class.forName(className);
                    if (Modifier.isAbstract(clazz.getModifiers())) continue;
                    if (TestCase.class.isAssignableFrom(clazz)) {
                        Class<?> testClass = clazz;
                        rootSuite.addTestSuite(testClass);
                        continue;
                    }
                    rootSuite.addTest((Test)new JUnit4TestAdapter(clazz));
                }
                catch (Throwable t) {
                    Logger.getLogger(RecursiveTestSuiteBuilder.class.getName()).log(Level.SEVERE, "Unable to load class ".concat(className), t);
                }
            }
        }
    }

    static class FileComparator
    implements Comparator<File> {
        FileComparator() {
        }

        @Override
        public int compare(File file1, File file2) {
            return file1.getAbsolutePath().compareTo(file2.getAbsolutePath());
        }
    }

    static class TestClassFilter
    implements FilenameFilter {
        TestClassFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            if (name.endsWith("Test.class")) {
                return true;
            }
            return new File(dir, name).isDirectory();
        }
    }
}

