/*
 * Decompiled with CFR 0.152.
 */
package net.reini.junit;

import java.io.BufferedReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.logging.Level;
import java.util.logging.Logger;
import junit.framework.JUnit4TestAdapter;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class CustomTestSuite {
    public static Test suite() {
        Logger logger = Logger.getLogger(CustomTestSuite.class.getName());
        TestSuite suite = new TestSuite("Custom JUnit tests");
        String customTestFile = System.getProperty("custom.tests", "");
        Path customTests = customTestFile.isEmpty() ? Paths.get(System.getProperty("user.dir"), "customtests") : Paths.get(customTestFile, new String[0]);
        if (Files.exists(customTests, new LinkOption[0]) && Files.isRegularFile(customTests, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(customTests, StandardCharsets.ISO_8859_1);){
                String className = null;
                while ((className = reader.readLine()) != null) {
                    if (!className.contains("/")) {
                        try {
                            Class<?> failedClass = Class.forName(className);
                            if (TestCase.class.isAssignableFrom(failedClass)) {
                                Class<?> testCase = failedClass;
                                suite.addTestSuite(testCase);
                                continue;
                            }
                            suite.addTest((Test)new JUnit4TestAdapter(failedClass));
                        }
                        catch (Exception e) {
                            logger.severe(String.format("Unable to load class %s (%s)", className, e.getClass().getName()));
                        }
                        continue;
                    }
                    logger.warning("Skipped Jython test ".concat(className));
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error getting tests from " + customTests, e);
            }
        }
        return suite;
    }
}

