/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.springboot.swagger;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
public class SwaggerConfig {
    @Value(value="${swagger.enabled:true}")
    protected Boolean swaggerEnabled;
    @Value(value="${swagger.package:empty}")
    protected String basePackage;
    @Value(value="${spring.application.name:extends shield-springboot}")
    protected String title;
    @Value(value="${project.groupId:}")
    protected String groupId;
    @Value(value="${project.artifactId:}")
    protected String artifactId;
    @Value(value="${project.version:1.0.0}")
    protected String version;
    @Value(value="${project.description:no description}")
    protected String description;
    @Value(value="${project.developer.name:SmartBear Software}")
    protected String name;
    @Value(value="${project.developer.url:https://swagger.io/}")
    protected String url;
    @Value(value="${project.developer.email:Info@SmartBear.com}")
    protected String email;

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).enable(this.swaggerEnabled.booleanValue()).select().paths(PathSelectors.any()).apis(RequestHandlerSelectors.basePackage((String)this.basePackage)).build().pathMapping("/");
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.title).description(String.format("%s<br>&lt;dependency&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;%s&lt;&#47;groupId&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;%s&lt;&#47;artifactId&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;%s&lt;&#47;version&gt;<br>&lt;&#47;dependency&gt;", this.description, this.groupId, this.artifactId, this.version)).contact(new Contact(this.name, this.url, this.email)).version(this.version).build();
    }
}

