package net.quanter.shield.springboot.config;

import lombok.Getter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * @author 王老实
 */
@Configuration
@EnableSwagger2
@Component
public class SwaggerConfig {

    @Autowired
    BootConfig bootConfig;

    /**
     * 是否开启swagger，正式环境一般是需要关闭的，可根据springboot的多环境配置进行设置
     */
    @Value(value = "${swagger.enabled:true}")
    @Getter
    protected Boolean swaggerEnabled;

    @Value(value = "${swagger.package:net.quanter}")
    @Getter
    protected String basePackage;

    @Getter
    protected Author author;

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2)
            .apiInfo(apiInfo())
            .enable(swaggerEnabled).select()
            .paths(PathSelectors.any())
            .apis(RequestHandlerSelectors.basePackage(basePackage))
            .build().pathMapping("/");
    }

    //设置api信息
    private ApiInfo apiInfo() {
        return new ApiInfoBuilder()
            .title(
                bootConfig.application.name)
            .description(
                String.format(
                    "%s<br>%s<br>&lt;dependency&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;%s&lt;&#47;groupId&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;"
                        + "%s&lt;&#47;artifactId&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;%s&lt;&#47;version&gt;<br>&lt;&#47;dependency&gt;",
                    bootConfig.project.description,
                    bootConfig.project.url,
                    bootConfig.project.groupId,
                    bootConfig.project.artifactId,
                    bootConfig.project.version))
            // 作者信息
            .contact(
                new Contact(
                    bootConfig.author.name,
                    bootConfig.author.url,
                    bootConfig.author.email))
            .version(bootConfig.project.version)
            .build();
    }
}
