package net.quanter.shield.springboot.config;

import java.io.Serializable;
import java.util.Map;

import com.github.xiaoymin.knife4j.spring.configuration.Knife4jAutoConfiguration;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import net.quanter.shield.common.dto.result.ResultDTO;
import net.quanter.shield.common.dto.result.wapper.ResultDTOMapWrapper;
import net.quanter.shield.springboot.h2.H2Config;
import org.h2.server.web.WebServlet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;
import javax.annotation.Resource;

/**
 *
 * @author 王老实
 */
@Component("shield-BootConfig")
@Slf4j
public class BootConfig implements Serializable, CommandLineRunner {

    @Value("${runtime.debug:false}")
    @Getter boolean debugMode;

    @Resource
    Application application;

    @Resource
    Author author;

    @Resource
    Runtime runtime;

    @Resource
    Project project;

    @Resource
    ApplicationContext context;

    /**
     * 是否启动了knife4j文档界面
     */
    Object knife4j;
    /**
     * 是否启动了H2
     */
    Object h2;

    @Getter
    private final ResultDTO<Map<String, Serializable>> configMap = ResultDTOMapWrapper.emptyMap();

    private final ResultDTOMapWrapper<String, Serializable> resultDTOMapWrapper = new ResultDTOMapWrapper(configMap);

    @Bean
    @ConditionalOnClass(Knife4jAutoConfiguration.class)
    @ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
    Object knife4jConfig(){
        knife4j = new Object();
        return knife4j;
    }

    @ConditionalOnClass(WebServlet.class)
    @ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
    Object h2Config(){
        h2 = new Object();
        return h2;
    }

    @Override
    public void run(String... args) throws Exception {
        log.info("------------------------------------------------");
        log.info("---springboot项目已启动");
        log.info("---应用信息:"+application);
        log.info("---项目信息:"+project);
        log.info("---作者信息:"+author);
        log.info("---运行环境:"+runtime);
        log.info("---您可以通过这个地址访问本项目首页:"+runtime.getIndexUrl());
        log.info("---您可以通过这个地址确认已经启动:"+runtime.getIndexUrl()+"/check");
        if(knife4j!=null){
            log.info("---您可以通过这个地址访问api文档:"+runtime.getIndexUrl()+"/doc.html");
        }
        if(context.containsBean("H2Config")){
            H2Config h2Config = context.getBean(H2Config.class);
            log.info("---您可以通过这个地址访问H2数据库:"+runtime.getIndexUrl()+h2Config.getH2ConsolePath());
        }
        if(debugMode){
            log.info("---您可以通过这个地址看到更完整的信息:"+runtime.getIndexUrl()+"/config");
            resultDTOMapWrapper.put("应用信息",application);
            resultDTOMapWrapper.put("项目信息",project);
            resultDTOMapWrapper.put("作者信息",author);
            resultDTOMapWrapper.put("运行环境",runtime);
        }
        log.info("------------------------------------------------");
    }
}
