/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.springboot.interceptor;

import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import net.quanter.shield.common.dto.context.InvocationContextDTO;
import net.quanter.shield.common.dto.context.InvocationDTO;
import net.quanter.shield.common.dto.result.ResultDTO;
import net.quanter.shield.common.enums.context.InvocationType;
import net.quanter.shield.common.enums.http.HttpCode;
import net.quanter.shield.utils.bean.BeanUtils;
import net.quanter.shield.utils.date.DateFormatter;
import net.quanter.shield.utils.invocation.InvocationUtil;
import net.quanter.shield.utils.string.StringComplexity;
import net.quanter.shield.utils.string.StringUtils;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
@Component
public class InvocationInterceptor {
    private static final String DEBBO_DEBUG = "DEBBO_DEBUG";
    private static final String TRACD_ID = "trace_id";

    @Pointcut(value="@annotation(net.quanter.shield.springboot.annotations.InvocationSupport)")
    private void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint invocation) throws Throwable {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = (HttpServletRequest)requestAttributes.resolveReference("request");
        String dubboDebug = request.getHeader(DEBBO_DEBUG);
        long begin = System.currentTimeMillis();
        InvocationDTO invocationDTO = null;
        InvocationContextDTO contextDTO = null;
        if (dubboDebug != null) {
            invocationDTO = new InvocationDTO();
            contextDTO = new InvocationContextDTO();
            String trace_id = request.getHeader(TRACD_ID);
            String traceId = StringUtils.isEmpty((CharSequence)trace_id) ? DateFormatter.formatNow((DateTimeFormatter)DateFormatter.DATE_FORMAT_FULL_SIMPLE) + StringUtils.genString((int)10, (StringComplexity)StringComplexity.LEVEL3) : trace_id.trim();
            contextDTO.setTraceId(traceId);
            contextDTO.setIndex(Integer.valueOf(0));
            invocationDTO.setIndex(contextDTO.getIndex());
            invocationDTO.setMethodName(invocation.getSignature().getName());
            invocationDTO.setServiceName(invocation.getTarget().getClass().getName());
            invocationDTO.setArgs(BeanUtils.clones((Object[])invocation.getArgs()));
            invocationDTO.setType(InvocationType.SPRINGBOOT);
            InvocationUtil.begin((InvocationContextDTO)contextDTO);
        }
        if (dubboDebug == null) {
            return invocation.proceed();
        }
        Object result = null;
        try {
            result = invocation.proceed();
        }
        catch (Throwable e) {
            result = ResultDTO.failure((String)e.getMessage(), (Integer)HttpCode.INTERNAL_SERVER_ERROR.code);
            invocationDTO.setE(e);
        }
        List invocationChain = InvocationUtil.getInvocationChain();
        invocationDTO.setRt(Long.valueOf(System.currentTimeMillis() - begin));
        invocationDTO.setChain(invocationChain);
        if (result != null && result instanceof ResultDTO) {
            invocationDTO.setResult(BeanUtils.clone((Object)result));
            ResultDTO resultDTO = (ResultDTO)result;
            resultDTO.putX("chain", (Object)invocationDTO);
            resultDTO.putX("tracdId", (Object)contextDTO.getTraceId());
        }
        InvocationUtil.end();
        return result;
    }
}

