/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.springboot.h2;

import javax.servlet.Servlet;
import org.h2.server.web.WebServlet;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.h2.H2ConsoleProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={H2ConsoleProperties.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={WebServlet.class})
@ConditionalOnProperty(prefix="spring.h2.console", name={"enabled"}, havingValue="true", matchIfMissing=false)
public class SheildH2ConsoleAutoConfiguration {
    @Value(value="${spring.h2.console.settings.ifExists:true}")
    boolean ifExists;
    private final H2ConsoleProperties properties;

    public SheildH2ConsoleAutoConfiguration(H2ConsoleProperties properties) {
        this.properties = properties;
    }

    @Primary
    @Bean
    public ServletRegistrationBean<WebServlet> Shieldh2Console() {
        String path;
        String urlMapping = path + ((path = this.properties.getPath()).endsWith("/") ? "*" : "/*");
        ServletRegistrationBean registration = new ServletRegistrationBean((Servlet)new WebServlet(), new String[]{urlMapping});
        H2ConsoleProperties.Settings settings = this.properties.getSettings();
        if (settings.isTrace()) {
            registration.addInitParameter("trace", "");
        }
        if (settings.isWebAllowOthers()) {
            registration.addInitParameter("webAllowOthers", "");
        }
        if (this.ifExists) {
            registration.addInitParameter("ifExists", "");
        } else {
            registration.addInitParameter("ifNotExists", "");
        }
        return registration;
    }
}

