/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.springboot.config;

import net.quanter.shield.springboot.config.Author;
import net.quanter.shield.springboot.config.BootConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@Component
public class SwaggerConfig {
    @Autowired
    BootConfig bootConfig;
    @Value(value="${swagger.enabled:true}")
    protected Boolean swaggerEnabled;
    @Value(value="${swagger.package:net.quanter}")
    protected String basePackage;
    protected Author author;

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).enable(this.swaggerEnabled.booleanValue()).select().paths(PathSelectors.any()).apis(RequestHandlerSelectors.basePackage((String)this.basePackage)).build().pathMapping("/");
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.bootConfig.application.description + "&nbsp;" + this.bootConfig.application.sourceUrl).description(String.format("%s<br>&lt;dependency&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;%s&lt;&#47;groupId&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;%s&lt;&#47;artifactId&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;%s&lt;&#47;version&gt;<br>&lt;&#47;dependency&gt;", this.bootConfig.application.description, this.bootConfig.project.groupId, this.bootConfig.project.artifactId, this.bootConfig.project.version)).contact(new Contact(this.bootConfig.author.name, this.bootConfig.author.url, this.bootConfig.author.email)).version(this.bootConfig.project.version).build();
    }

    public Boolean getSwaggerEnabled() {
        return this.swaggerEnabled;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public Author getAuthor() {
        return this.author;
    }
}

