/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.springboot.config;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class Runtime
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Runtime.class);
    @Value(value="${runtime.environment:local}")
    String env;
    @Value(value="${server.servlet.context-path:}")
    String contextPath;
    @Value(value="${server.port:8080}")
    private int port;
    private String host;
    private int pid;
    @Value(value="${logging.file.path:}")
    private String loggingFilePath;
    private String indexUrl;
    private String localIp;

    @PostConstruct
    public void init() {
        try {
            this.localIp = InetAddress.getLocalHost().getHostAddress();
            String name = ManagementFactory.getRuntimeMXBean().getName();
            String[] names = name.split("@");
            this.pid = Integer.parseInt(names[0]);
            this.host = names[1];
            this.indexUrl = "http://" + this.localIp + ":" + this.port + this.contextPath;
        }
        catch (Throwable e) {
            log.error("\u89e3\u6790pid\u9519\u8bef", e);
        }
    }

    public String toString() {
        return "Runtime{env='" + this.env + "', contextPath='" + this.contextPath + "', port=" + this.port + ", host='" + this.host + "', pid=" + this.pid + ", loggingFilePath='" + this.loggingFilePath + "', indexUrl='" + this.indexUrl + "', localIp='" + this.localIp + "'}";
    }

    public String getEnv() {
        return this.env;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public int getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public int getPid() {
        return this.pid;
    }

    public String getLoggingFilePath() {
        return this.loggingFilePath;
    }

    public String getIndexUrl() {
        return this.indexUrl;
    }

    public String getLocalIp() {
        return this.localIp;
    }
}

