/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.springboot.config;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import net.quanter.shield.common.dto.result.ResultDTO;
import net.quanter.shield.common.dto.result.wapper.ResultDTOMapWrapper;
import net.quanter.shield.springboot.config.Application;
import net.quanter.shield.springboot.config.Author;
import net.quanter.shield.springboot.config.Project;
import net.quanter.shield.springboot.config.Runtime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class BootConfig
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(BootConfig.class);
    @Value(value="${runtime.debug:false}")
    boolean debugMode;
    @Resource
    Application application;
    @Resource
    Author author;
    @Resource
    Runtime runtime;
    @Resource
    Project project;
    private final ResultDTO<Map<String, Serializable>> configMap = ResultDTOMapWrapper.emptyMap();
    private final ResultDTOMapWrapper<String, Serializable> resultDTOMapWrapper = new ResultDTOMapWrapper(this.configMap);

    @PostConstruct
    public void init() {
        log.info("------------------------------------------------");
        log.info("---springboot\u9879\u76ee\u5df2\u542f\u52a8");
        log.info("---\u9879\u76ee\u4fe1\u606f:" + this.application);
        log.info("---\u4f5c\u8005\u4fe1\u606f:" + this.author);
        log.info("---\u8fd0\u884c\u73af\u5883:" + this.runtime);
        log.info("---\u60a8\u53ef\u4ee5\u901a\u8fc7\u8fd9\u4e2a\u5730\u5740\u8bbf\u95ee\u672c\u9879\u76ee\u9996\u9875:" + this.runtime.getIndexUrl());
        log.info("---\u60a8\u53ef\u4ee5\u901a\u8fc7\u8fd9\u4e2a\u5730\u5740\u786e\u8ba4\u5df2\u7ecf\u542f\u52a8:" + this.runtime.getIndexUrl() + "/check");
        if (this.debugMode) {
            log.info("---\u60a8\u53ef\u4ee5\u901a\u8fc7\u8fd9\u4e2a\u5730\u5740\u770b\u5230\u66f4\u5b8c\u6574\u7684\u4fe1\u606f:" + this.runtime.getIndexUrl() + "/debug");
            this.resultDTOMapWrapper.put((Serializable)((Object)"\u9879\u76ee\u4fe1\u606f"), (Serializable)this.application);
            this.resultDTOMapWrapper.put((Serializable)((Object)"\u4f5c\u8005\u4fe1\u606f"), (Serializable)this.author);
            this.resultDTOMapWrapper.put((Serializable)((Object)"\u8fd0\u884c\u73af\u5883"), (Serializable)this.runtime);
        }
        log.info("------------------------------------------------");
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public ResultDTO<Map<String, Serializable>> getConfigMap() {
        return this.configMap;
    }
}

