package net.quanter.shield.springboot.config;

import java.io.Serializable;
import java.util.Map;

import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import net.quanter.shield.common.dto.result.ResultDTO;
import net.quanter.shield.common.dto.result.wapper.ResultDTOMapWrapper;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;

/**
 *
 * @author 王老实
 */
@Component
@Slf4j
public class BootConfig implements Serializable{

    @Value("${runtime.debug:false}")
    @Getter boolean debugMode;

    @Resource
    Application application;

    @Resource
    Author author;

    @Resource
    Runtime runtime;

    @Resource
    Project project;

    @Getter
    private final ResultDTO<Map<String, Serializable>> configMap = ResultDTOMapWrapper.emptyMap();

    private final ResultDTOMapWrapper<String, Serializable> resultDTOMapWrapper = new ResultDTOMapWrapper(configMap);

    @PostConstruct
    public void init(){
        log.info("------------------------------------------------");
        log.info("---springboot项目已启动");
        log.info("---项目信息:"+application);
        log.info("---作者信息:"+author);
        log.info("---运行环境:"+runtime);
        log.info("---您可以通过这个地址访问本项目首页:"+runtime.getIndexUrl());
        log.info("---您可以通过这个地址确认已经启动:"+runtime.getIndexUrl()+"/check");
        if(debugMode){
            log.info("---您可以通过这个地址看到更完整的信息:"+runtime.getIndexUrl()+"/debug");
            resultDTOMapWrapper.put("项目信息",application);
            resultDTOMapWrapper.put("作者信息",author);
            resultDTOMapWrapper.put("运行环境",runtime);
        }
        log.info("------------------------------------------------");
    }
}
