package net.quanter.shield.springboot.config;

import java.io.Serializable;

import lombok.Getter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/**
 * @author 王老实
 */
@Component
public class Application implements Serializable {
    @Value("${spring.application.name:FROM SHIELD-SPRINGBOOT}")
    @Getter
    String name;

    @Value(value="${project.description:}")
    @Getter
    String description;

    @Value(value = "${project.url:}")
    @Getter
    String sourceUrl;

    @Override
    public String toString() {
        return "Application{" +
                "name='" + name + '\'' +
                ", description='" + description + '\'' +
                ", sourceUrl='" + sourceUrl + '\'' +
                '}';
    }
}
