/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.springboot.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@EnableSwagger2
@Component
public class SwaggerConfig {
    @Value(value="${swagger.enabled:true}")
    protected Boolean swaggerEnabled;
    @Value(value="${swagger.package:net.quanter}")
    protected String basePackage;
    @Value(value="${spring.application.name:extends shield-springboot}")
    protected String title;
    @Value(value="${project.groupId:}")
    protected String groupId;
    @Value(value="${project.artifactId:}")
    protected String artifactId;
    @Value(value="${project.version:1.0.0}")
    protected String version;
    @Value(value="${project.url:}")
    protected String projectUrl;
    @Value(value="${project.description:\u5fd8\u4e86\u914d\u7f6e[\u9700\u8981\u5728alication.xml\u91cc\u914d\u7f6eproject.description]}")
    protected String description;
    @Value(value="${project.developer.name:\u65e0\u540d\u6c0f}")
    protected String name;
    @Value(value="${project.developer.url:\u5fd8\u4e86\u914d\u7f6e[\u9700\u8981\u5728application.xml\u91cc\u914d\u7f6eproject.developer.url]}")
    protected String url;
    @Value(value="${project.developer.email:\u5fd8\u4e86\u914d\u7f6e[\u9700\u8981\u5728application.xml\u91cc\u914d\u7f6eproject.developer.email]}")
    protected String email;

    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.SWAGGER_2).apiInfo(this.apiInfo()).enable(this.swaggerEnabled.booleanValue()).select().paths(PathSelectors.any()).apis(RequestHandlerSelectors.basePackage((String)this.basePackage)).build().pathMapping("/");
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title(this.title + "&nbsp;" + this.projectUrl).description(String.format("%s<br>&lt;dependency&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;groupId&gt;%s&lt;&#47;groupId&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;artifactId&gt;%s&lt;&#47;artifactId&gt;<br>&nbsp;&nbsp;&nbsp;&nbsp;&lt;version&gt;%s&lt;&#47;version&gt;<br>&lt;&#47;dependency&gt;", this.description, this.groupId, this.artifactId, this.version)).contact(new Contact(this.name, this.url, this.email)).version(this.version).build();
    }

    public Boolean getSwaggerEnabled() {
        return this.swaggerEnabled;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public String getTitle() {
        return this.title;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getProjectUrl() {
        return this.projectUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getEmail() {
        return this.email;
    }
}

