/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.springboot.interceptor;

import cn.hutool.core.util.NumberUtil;
import javax.servlet.http.HttpServletRequest;
import net.quanter.shield.mybatis.page.PageUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Aspect
@Component
public class PageInterceptor {
    private static final Logger log = LoggerFactory.getLogger(PageInterceptor.class);

    @Pointcut(value="@annotation(net.quanter.shield.springboot.annotations.PageSupport)")
    private void pointcut() {
    }

    @Before(value="pointcut()")
    public void before(JoinPoint joinPoint) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = (HttpServletRequest)requestAttributes.resolveReference("request");
        String sPageNum = request.getParameter("pageNum");
        String sPageSize = request.getParameter("pageSize");
        if (sPageNum == null || sPageSize == null) {
            return;
        }
        boolean isPageNumValid = NumberUtil.isInteger((String)sPageNum);
        boolean isPageSizeValid = NumberUtil.isInteger((String)sPageSize);
        if (isPageNumValid) {
            log.error("pageNum[{}] is not a number", (Object)sPageNum);
        }
        if (isPageSizeValid) {
            log.error("pageSize[{}] is not a number", (Object)sPageSize);
        }
        Integer pageNum = isPageNumValid ? Integer.parseInt(sPageNum) : 1;
        Integer pageSize = isPageSizeValid ? Integer.parseInt(sPageSize) : 10;
        PageUtil.set((Integer)pageNum, (Integer)pageSize);
    }

    @After(value="pointcut()")
    public void afterCompletion() throws Exception {
        PageUtil.remove();
    }
}

