package net.quanter.shield.springboot.interceptor;

import lombok.extern.slf4j.Slf4j;
import net.quanter.shield.mybatis.page.PageUtil;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

import javax.servlet.http.HttpServletRequest;

/**
 * 分页拦截器，拦截web请求，直接把pageNum和pageSize放到前端中
 * Created by 2016/11/24.
 *
 * @author 王老实
 */
@Aspect
@Component
@Slf4j
public class PageInterceptor {

    @Pointcut("@annotation(net.quanter.shield.springboot.annotations.PageSupport)")
    private void pointcut() {}

    @Before(value = "pointcut()")
    public void before(JoinPoint joinPoint) {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        //从获取RequestAttributes中获取HttpServletRequest的信息
        HttpServletRequest request = (HttpServletRequest)requestAttributes.resolveReference(RequestAttributes.REFERENCE_REQUEST);
        String sPageNum = request.getParameter("pageNum");
        String sPageSize = request.getParameter("pageSize");
        if (sPageNum == null || sPageSize == null) {
            return;
        }
        try {
            Integer pageNum = Integer.parseInt(sPageNum);
            Integer pageSize = Integer.parseInt(sPageSize);
            PageUtil.set(pageNum, pageSize);
        } catch (NumberFormatException e) {
            log.info("PageInterceptor NumFormatException,pageNum={},pageSize={}", sPageNum, sPageSize);
            PageUtil.set(1, PageUtil.DEFAULT_PAGE_DTO.getPageSize());
        }
    }

    @After(value = "pointcut()")
    public void afterCompletion() throws Exception {
        PageUtil.remove();
    }

}

