/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.mybatis.pagehelper;

import com.github.pagehelper.ISelect;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import java.util.HashMap;
import java.util.Map;
import net.quanter.shield.common.dto.page.FullPageInfoDTO;
import net.quanter.shield.common.dto.page.FullPageResultDTO;
import net.quanter.shield.common.dto.page.PageDTO;
import net.quanter.shield.common.dto.page.PageInfoDTO;
import net.quanter.shield.common.dto.page.PageResultDTO;

public class PageUtil {
    private static final ThreadLocal<Map<String, PageDTO>> threadMap = new ThreadLocal();
    private static final ThreadLocal<PageDTO> thread = new ThreadLocal();
    private static final PageDTO defaultPageDTO = new PageDTO(10);

    public static <T> PageResultDTO<T> doSelectInfo(ISelect select) {
        PageDTO pageDTO = PageUtil.get();
        if (pageDTO == null) {
            pageDTO = defaultPageDTO;
        }
        PageInfo pageInfo = PageHelper.startPage((int)pageDTO.getPageNum(), (int)pageDTO.getPageSize(), (boolean)true, (Boolean)pageDTO.getReasonable(), (Boolean)pageDTO.getPageSizeZero()).doSelectPageInfo(select);
        return PageUtil.create(pageInfo);
    }

    public static <T> FullPageResultDTO<T> doSelectInfoFull(ISelect select) {
        PageDTO pageDTO = PageUtil.get();
        if (pageDTO == null) {
            pageDTO = defaultPageDTO;
        }
        PageInfo pageInfo = PageHelper.startPage((int)pageDTO.getPageNum(), (int)pageDTO.getPageSize(), (boolean)true, (Boolean)pageDTO.getReasonable(), (Boolean)pageDTO.getPageSizeZero()).doSelectPageInfo(select);
        return PageUtil.createFull(pageInfo);
    }

    public static void set(Integer pageNum, Integer pageSize) {
        PageDTO page = new PageDTO();
        page.setPageNum(pageNum.intValue());
        page.setPageSize(pageSize.intValue());
        thread.set(page);
    }

    public static void set(String name, Integer pageNum, Integer pageSize) {
        PageDTO page = new PageDTO();
        page.setPageNum(pageNum.intValue());
        page.setPageSize(pageSize.intValue());
        PageUtil.set(name, page);
    }

    public static void set(String name, PageDTO page) {
        Map<String, PageDTO> map = threadMap.get();
        if (map == null || !map.containsKey(name)) {
            map = new HashMap<String, PageDTO>();
        }
        map.put(name, page);
        threadMap.set(map);
    }

    public static PageDTO get() {
        return thread.get();
    }

    public static PageDTO get(String name) {
        if (threadMap.get() == null) {
            return null;
        }
        Map<String, PageDTO> map = threadMap.get();
        if (map == null || !map.containsKey(name)) {
            return null;
        }
        return map.get(name);
    }

    public static void remove() {
        threadMap.remove();
        thread.remove();
    }

    protected static <T> PageResultDTO<T> create(PageInfo<T> pageInfo) {
        PageInfoDTO pageInfoDTO = new PageInfoDTO();
        pageInfoDTO.setPageNum(pageInfo.getPageNum());
        pageInfoDTO.setPageSize(pageInfo.getPageSize());
        pageInfoDTO.setTotal(pageInfo.getTotal());
        PageResultDTO pageResultDTO = new PageResultDTO(pageInfo.getList(), pageInfoDTO);
        return pageResultDTO;
    }

    protected static <T> FullPageResultDTO<T> createFull(PageInfo pageInfo) {
        FullPageInfoDTO pageInfoDTO = new FullPageInfoDTO();
        pageInfoDTO.setStartRow(pageInfo.getStartRow());
        pageInfoDTO.setPageSize(pageInfo.getPageSize());
        pageInfoDTO.setTotal(pageInfo.getTotal());
        pageInfoDTO.setSize(pageInfo.getSize());
        pageInfoDTO.setStartRow(pageInfo.getStartRow());
        pageInfoDTO.setEndRow(pageInfo.getEndRow());
        pageInfoDTO.setPages(pageInfo.getPages());
        pageInfoDTO.setPrePage(pageInfo.getPrePage());
        pageInfoDTO.setNextPage(pageInfo.getNextPage());
        pageInfoDTO.setFirstPage(pageInfo.isIsFirstPage());
        pageInfoDTO.setLastPage(pageInfo.isIsLastPage());
        pageInfoDTO.setHasPreviousPage(pageInfo.isHasPreviousPage());
        pageInfoDTO.setHasNextPage(pageInfo.isHasNextPage());
        pageInfoDTO.setNavigateFirstPage(pageInfo.getNavigateFirstPage());
        pageInfoDTO.setNavigateLastPage(pageInfo.getNavigateLastPage());
        pageInfoDTO.setNavigatepageNums(pageInfo.getNavigatepageNums());
        pageInfoDTO.setNavigatePages(pageInfo.getNextPage());
        FullPageResultDTO pageResultDTO = new FullPageResultDTO(pageInfo.getList(), pageInfoDTO);
        return pageResultDTO;
    }
}

