package net.quanter.shield.mybatis.pagehelper;

import com.github.pagehelper.ISelect;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import net.quanter.shield.common.dto.page.*;

import java.util.HashMap;
import java.util.Map;

public class PageUtil {

    //一个请求多个分页时所使用的线程变量
    private final static ThreadLocal<Map<String, PageDTO>> threadMap = new ThreadLocal<Map<String, PageDTO>>();
    //一个请求单个分页时所使用的线程变量
    private final static ThreadLocal<PageDTO> thread = new ThreadLocal<PageDTO>();
    private static final PageDTO defaultPageDTO = new PageDTO(10);

    public static <T> PageResultDTO<T> doSelectInfo(ISelect select){
        PageDTO pageDTO = get();
        if(pageDTO==null){
            pageDTO = defaultPageDTO;
        }
        PageInfo pageInfo = PageHelper
                .startPage(pageDTO.getPageNum(),pageDTO.getPageSize(),true,pageDTO.getReasonable(),pageDTO.getPageSizeZero())
                .doSelectPageInfo(select);
        return create(pageInfo);
    }

    public static <T> FullPageResultDTO<T> doSelectInfoFull(ISelect select){
        PageDTO pageDTO = get();
        if(pageDTO==null){
            pageDTO = defaultPageDTO;
        }
        PageInfo pageInfo = PageHelper
                .startPage(pageDTO.getPageNum(),pageDTO.getPageSize(),true,pageDTO.getReasonable(),pageDTO.getPageSizeZero())
                .doSelectPageInfo(select);
        return createFull(pageInfo);
    }

    public static void set(Integer pageNum,Integer pageSize){
        PageDTO page = new PageDTO();
        page.setPageNum(pageNum);
        page.setPageSize(pageSize);
        thread.set(page);
    }

    public static void set(String name,Integer pageNum,Integer pageSize){
        PageDTO page = new PageDTO();
        page.setPageNum(pageNum);
        page.setPageSize(pageSize);
        set(name,page);
    }

    public static void set(String name, PageDTO page){
        Map<String, PageDTO> map = threadMap.get();
        if(map==null || !map.containsKey(name)){
            map = new HashMap();
        }
        map.put(name,page);
        threadMap.set(map);
    }

    public static PageDTO get(){
        return thread.get();
    }


    public static PageDTO get(String name){
        if(threadMap.get()==null){
            return null;
        }
        Map<String, PageDTO> map = threadMap.get();
        if(map==null || !map.containsKey(name)){
            return null;
        }
        return map.get(name);
    }

    public static void remove(){
        threadMap.remove();
        thread.remove();
    }

    protected static <T> PageResultDTO<T> create(PageInfo<T> pageInfo){
        PageInfoDTO pageInfoDTO = new PageInfoDTO();
        pageInfoDTO.setPageNum(pageInfo.getPageNum());
        pageInfoDTO.setPageSize(pageInfo.getPageSize());
        pageInfoDTO.setTotal(pageInfo.getTotal());
        PageResultDTO<T> pageResultDTO = new PageResultDTO(pageInfo.getList(),pageInfoDTO);
        return pageResultDTO;
    }

    protected static <T> FullPageResultDTO<T> createFull(PageInfo pageInfo){
        FullPageInfoDTO pageInfoDTO = new FullPageInfoDTO();
        pageInfoDTO.setStartRow(pageInfo.getStartRow());
        pageInfoDTO.setPageSize(pageInfo.getPageSize());
        pageInfoDTO.setTotal(pageInfo.getTotal());
        pageInfoDTO.setSize(pageInfo.getSize());
        pageInfoDTO.setStartRow(pageInfo.getStartRow());
        pageInfoDTO.setEndRow(pageInfo.getEndRow());
        pageInfoDTO.setPages(pageInfo.getPages());
        pageInfoDTO.setPrePage(pageInfo.getPrePage());
        pageInfoDTO.setNextPage(pageInfo.getNextPage());
        pageInfoDTO.setFirstPage(pageInfo.isIsFirstPage());
        pageInfoDTO.setLastPage(pageInfo.isIsLastPage());
        pageInfoDTO.setHasPreviousPage(pageInfo.isHasPreviousPage());
        pageInfoDTO.setHasNextPage(pageInfo.isHasNextPage());
        pageInfoDTO.setNavigateFirstPage(pageInfo.getNavigateFirstPage());
        pageInfoDTO.setNavigateLastPage(pageInfo.getNavigateLastPage());
        pageInfoDTO.setNavigatepageNums(pageInfo.getNavigatepageNums());
        pageInfoDTO.setNavigatePages(pageInfo.getNextPage());
        FullPageResultDTO pageResultDTO = new FullPageResultDTO(pageInfo.getList(),pageInfoDTO);
        return pageResultDTO;
    }
}
