package net.quanter.shield.mybatis.base;

import org.apache.ibatis.annotations.Param;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * 公共父类
 * @param <E> 实体类类型
 * @param <ID> 实体类主键类型
 */
public interface  BaseMapper<E, ID extends Serializable> {
    int insert(E entity);

    int batchInsert(Collection<E> list);

    int delete(ID id);

    int batchDelete(Collection<ID> idList);

    int update(E entity);

    E get(ID id);

    List<E> find(E query);

    List<E> findByIds(Collection<ID> ids);

    Set<E> findToSet(E query);

    Set<E> findToSetByIds(Collection<ID> ids);

    List<E> findAll(@Param("start") Integer start, @Param("limit") Integer limit);

    int count(E query);
}