/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.mybatis.pagehelper;

import java.util.HashMap;
import java.util.Map;
import net.quanter.shield.mybatis.pagehelper.PageDTO;

public class PageUtil {
    private static final ThreadLocal<Map<String, PageDTO>> threadMap = new ThreadLocal();
    private static final ThreadLocal<PageDTO> thread = new ThreadLocal();

    public static void set(Integer pageNum, Integer pageSize) {
        PageDTO page = new PageDTO();
        page.setPageNum(pageNum);
        page.setPageSize(pageSize);
        thread.set(page);
    }

    public static void set(String name, Integer pageNum, Integer pageSize) {
        PageDTO page = new PageDTO();
        page.setPageNum(pageNum);
        page.setPageSize(pageSize);
        PageUtil.set(name, page);
    }

    public static void set(String name, PageDTO page) {
        Map<String, PageDTO> map = threadMap.get();
        if (map == null || !map.containsKey(name)) {
            map = new HashMap<String, PageDTO>();
        }
        map.put(name, page);
        threadMap.set(map);
    }

    public static PageDTO get() {
        return thread.get();
    }

    public static PageDTO get(String name) {
        if (threadMap.get() == null) {
            return null;
        }
        Map<String, PageDTO> map = threadMap.get();
        if (map == null || !map.containsKey(name)) {
            return null;
        }
        return map.get(name);
    }

    public static void remove() {
        threadMap.remove();
        thread.remove();
    }
}

