/*
 * Decompiled with CFR 0.152.
 */
package net.quanter.shield.mybatis.pagehelper;

import com.github.pagehelper.Page;
import com.github.pagehelper.dialect.AbstractHelperDialect;
import com.github.pagehelper.util.MetaObjectUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.Id;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.reflection.MetaObject;

public class CacheDialect
extends AbstractHelperDialect {
    ThreadLocal<String> currentIdColumnName = new ThreadLocal();

    public Object processPageParameter(MappedStatement ms, Map<String, Object> paramMap, Page page, BoundSql boundSql, CacheKey pageKey) {
        if (page.getStartRow() > 0) {
            List resultMaps = ms.getResultMaps();
            String id = null;
            block0: for (ResultMap resultMap : resultMaps) {
                List resultMappingList = resultMap.getIdResultMappings();
                if (resultMappingList.isEmpty()) {
                    Field[] fields;
                    Class resultClass = resultMap.getType();
                    for (Field field : fields = resultClass.getDeclaredFields()) {
                        boolean oldAccessible = field.isAccessible();
                        field.setAccessible(true);
                        Id annotation = field.getAnnotation(Id.class);
                        if (annotation != null) {
                            id = field.getName();
                        }
                        field.setAccessible(oldAccessible);
                        if (id != null) continue block0;
                    }
                    continue;
                }
                id = ((ResultMapping)resultMappingList.get(0)).getColumn();
            }
            if (id == null) {
                id = "id";
            }
            this.currentIdColumnName.set(id);
            int param_old_size = boundSql.getParameterMappings().size();
            ArrayList<ParameterMapping> newParameterMappings = new ArrayList<ParameterMapping>(boundSql.getParameterMappings());
            for (int i = 0; i < param_old_size; ++i) {
                ParameterMapping parameterMapping = (ParameterMapping)boundSql.getParameterMappings().get(i);
                String key = "param" + (i + 1);
                Object value = paramMap.get(key);
                paramMap.put("param" + (param_old_size + i + 1), value);
                pageKey.update(value);
                newParameterMappings.add(new ParameterMapping.Builder(ms.getConfiguration(), parameterMapping.getProperty(), parameterMapping.getTypeHandler()).build());
            }
            MetaObject metaObject = MetaObjectUtil.forObject((Object)boundSql);
            metaObject.setValue("parameterMappings", newParameterMappings);
        }
        return paramMap;
    }

    public String getPageSql(String sql, Page page, CacheKey pageKey) {
        if (page.getStartRow() == 0) {
            String fullsql = String.format("select top %d * from (%s) a", page.getPageSize(), sql, sql);
            return fullsql;
        }
        String id_columns = this.currentIdColumnName.get();
        this.currentIdColumnName.remove();
        String fullsql = String.format("select top %d * from (%s) a where a.%s not in (select top %d %s from (%s) b)", page.getPageSize(), sql, id_columns, page.getStartRow(), id_columns, sql);
        return fullsql;
    }
}

