package net.quanter.shield.mybatis.pagehelper;

import java.util.HashMap;
import java.util.Map;

public class PageUtil {

    //一个请求多个分页时所使用的线程变量
    private final static ThreadLocal<Map<String, PageDTO>> threadMap = new ThreadLocal<Map<String, PageDTO>>();
    //一个请求单个分页时所使用的线程变量
    private final static ThreadLocal<PageDTO> thread = new ThreadLocal<PageDTO>();

    public static void set(Integer pageNum,Integer pageSize){
        PageDTO page = new PageDTO();
        page.setPageNum(pageNum);
        page.setPageSize(pageSize);
        thread.set(page);
    }

    public static void set(String name,Integer pageNum,Integer pageSize){
        PageDTO page = new PageDTO();
        page.setPageNum(pageNum);
        page.setPageSize(pageSize);
        set(name,page);
    }

    public static void set(String name, PageDTO page){
        Map<String, PageDTO> map = threadMap.get();
        if(map==null || !map.containsKey(name)){
            map = new HashMap();
        }
        map.put(name,page);
        threadMap.set(map);
    }

    public static PageDTO get(){
        return thread.get();
    }


    public static PageDTO get(String name){
        if(threadMap.get()==null){
            return null;
        }
        Map<String, PageDTO> map = threadMap.get();
        if(map==null || !map.containsKey(name)){
            return null;
        }
        return map.get(name);
    }

    public static void remove(){
        threadMap.remove();
        thread.remove();
    }
}
