package net.quanter.shield.mybatis.pagehelper;

import com.github.pagehelper.ISelect;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import lombok.Getter;
import net.quanter.shield.common.dto.ResultDTO;

import java.util.List;

public class PageResultDTO<T> extends ResultDTO<List<T>> {

    /** 分页对象 */
    @Getter
    private PageInfoDTO page;

    private static final PageDTO defaultPageDTO = new PageDTO(10);

    public PageResultDTO() {
    }

    public PageResultDTO(List<T> data) {
        super(data);
    }

    public PageResultDTO(List<T> data, PageInfoDTO pageInfoDTO) {
        super(data);
        this.page = pageInfoDTO;
    }

    public PageResultDTO(boolean success, String message,String code, List<T> data) {
        super(success, message,code, data);
    }

    public PageResultDTO(ResultDTO<List<T>> result) {
        super(result);
    }

    public static <T> PageResultDTO<T> doSelectInfo(ISelect select){
        PageDTO pageDTO = PageUtil.get();
        if(pageDTO==null){
            pageDTO = defaultPageDTO;
        }
        PageInfo<T> pageInfo = PageHelper
                .startPage(pageDTO.getPageNum(),pageDTO.getPageSize(),true,pageDTO.getReasonable(),pageDTO.getPageSizeZero())
                .doSelectPageInfo(select);
        return create(pageInfo);
    }

    protected static <T> PageResultDTO<T> create(PageInfo<T> pageInfo){
        PageInfoDTO pageInfoDTO = new PageInfoDTO();
        pageInfoDTO.setPageNum(pageInfo.getPageNum());
        pageInfoDTO.setPageSize(pageInfo.getPageSize());
        pageInfoDTO.setTotal(pageInfo.getTotal());
        PageResultDTO<T> pageResultDTO = new PageResultDTO(pageInfo.getList(),pageInfoDTO);
        return pageResultDTO;
    }
}
