/*
 * Decompiled with CFR 0.152.
 */
package net.qihoo.qconf;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import net.qihoo.qconf.QconfException;

public class Qconf {
    private static final String QCONF_DRIVER_JAVA_VERSION = "1.1.0";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadLib() throws IOException {
        String libFullName = "libqconf_java.so";
        InputStream in = null;
        BufferedInputStream reader = null;
        FileOutputStream writer = null;
        File extractedLibFile = File.createTempFile("libqconf_java", ".so");
        try {
            in = Qconf.class.getResourceAsStream(File.separator + libFullName);
            reader = new BufferedInputStream(in);
            writer = new FileOutputStream(extractedLibFile);
            byte[] buffer = new byte[1024];
            while (reader.read(buffer) > 0) {
                writer.write(buffer);
                buffer = new byte[1024];
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        System.load(extractedLibFile.toString());
        if (extractedLibFile.exists()) {
            extractedLibFile.delete();
        }
    }

    private static void exceptionCallback(String errmsg) throws QconfException {
        throw new QconfException(errmsg);
    }

    private static native int init() throws QconfException;

    private static native int destroy();

    public static String version() {
        return QCONF_DRIVER_JAVA_VERSION;
    }

    public static native String getConf(String var0, String var1) throws QconfException;

    public static String getConf(String key) throws QconfException {
        return Qconf.getConf(key, null);
    }

    public static native String getHost(String var0, String var1) throws QconfException;

    public static String getHost(String key) throws QconfException {
        return Qconf.getHost(key, null);
    }

    public static native ArrayList<String> getAllHost(String var0, String var1) throws QconfException;

    public static ArrayList<String> getAllHost(String key) throws QconfException {
        return Qconf.getAllHost(key, null);
    }

    public static native Map<String, String> getBatchConf(String var0, String var1) throws QconfException;

    public static Map<String, String> getBatchConf(String key) throws QconfException {
        return Qconf.getBatchConf(key, null);
    }

    public static native ArrayList<String> getBatchKeys(String var0, String var1) throws QconfException;

    public static ArrayList<String> getBatchKeys(String key) throws QconfException {
        return Qconf.getBatchKeys(key, null);
    }

    static {
        try {
            Qconf.loadLib();
        }
        catch (IOException e) {
            System.err.println("load qconf library failed");
            System.exit(1);
        }
        try {
            Qconf.init();
        }
        catch (QconfException e) {
            System.err.println("initial qconf environment failed");
            System.exit(1);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Qconf.destroy();
            }
        });
    }
}

