/*
 * Decompiled with CFR 0.152.
 */
package space.vectrix.flare.fastutil;

import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import it.unimi.dsi.fastutil.shorts.AbstractShort2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectFunction;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMaps;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.IntFunction;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import space.vectrix.flare.fastutil.Short2ObjectSyncMap;

final class Short2ObjectSyncMapImpl<V>
extends AbstractShort2ObjectMap<V>
implements Short2ObjectSyncMap<V> {
    private static final long serialVersionUID = 1L;
    private final transient Object lock = new Object();
    private volatile transient Short2ObjectMap<Short2ObjectSyncMap.ExpungingEntry<V>> read;
    private volatile transient boolean amended;
    private transient Short2ObjectMap<Short2ObjectSyncMap.ExpungingEntry<V>> dirty;
    private transient int misses;
    private final transient IntFunction<Short2ObjectMap<Short2ObjectSyncMap.ExpungingEntry<V>>> function;
    private transient EntrySetView entrySet;

    Short2ObjectSyncMapImpl(@NonNull IntFunction<Short2ObjectMap<Short2ObjectSyncMap.ExpungingEntry<V>>> function, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Initial capacity must be greater than 0");
        }
        this.function = function;
        this.read = function.apply(initialCapacity);
    }

    @Override
    public int size() {
        this.promote();
        int size = 0;
        for (Short2ObjectSyncMap.ExpungingEntry value : this.read.values()) {
            if (!value.exists()) continue;
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        this.promote();
        for (Short2ObjectSyncMap.ExpungingEntry value : this.read.values()) {
            if (!value.exists()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        for (Short2ObjectMap.Entry entry2 : this.short2ObjectEntrySet()) {
            if (!Objects.equals(entry2.getValue(), value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsKey(short key) {
        Short2ObjectSyncMap.ExpungingEntry<V> entry2 = this.getEntry(key);
        return entry2 != null && entry2.exists();
    }

    @Override
    public @Nullable V get(short key) {
        Short2ObjectSyncMap.ExpungingEntry<V> entry2 = this.getEntry(key);
        return entry2 != null ? (V)entry2.get() : null;
    }

    @Override
    public @NonNull V getOrDefault(short key, @NonNull V defaultValue) {
        Objects.requireNonNull(defaultValue, "defaultValue");
        Short2ObjectSyncMap.ExpungingEntry<V> entry2 = this.getEntry(key);
        return entry2 != null ? entry2.getOr(defaultValue) : defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable Short2ObjectSyncMap.ExpungingEntry<V> getEntry(short key) {
        Short2ObjectSyncMap.ExpungingEntry entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        if (entry2 == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry2 == null && this.amended && this.dirty != null) {
                    entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key);
                    this.missLocked();
                }
            }
        }
        return entry2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable V computeIfAbsent(short key, @NonNull IntFunction<? extends V> mappingFunction) {
        Short2ObjectSyncMap.InsertionResult<Object> result2;
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        Short2ObjectSyncMap.ExpungingEntry entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Short2ObjectSyncMap.InsertionResult<V> insertionResult = result2 = entry2 != null ? entry2.computeIfAbsent(key, mappingFunction) : null;
        if (result2 != null && result2.operation() == 1) {
            return result2.current();
        }
        Object object = this.lock;
        synchronized (object) {
            entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry2 != null) {
                if (entry2.tryUnexpungeAndCompute(key, mappingFunction)) {
                    if (entry2.exists()) {
                        this.dirty.put(key, (Short2ObjectSyncMap.ExpungingEntry<Short2ObjectSyncMap.ExpungingEntry>)entry2);
                    }
                    return entry2.get();
                }
                result2 = entry2.computeIfAbsent(key, mappingFunction);
            } else if (this.dirty != null && (entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                result2 = entry2.computeIfAbsent(key, mappingFunction);
                if (result2.current() == null) {
                    this.dirty.remove(key);
                }
                this.missLocked();
            } else {
                V computed;
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                if ((computed = mappingFunction.apply(key)) != null) {
                    this.dirty.put(key, (Short2ObjectSyncMap.ExpungingEntry<ExpungingEntryImpl<V>>)new ExpungingEntryImpl<V>(computed));
                }
                return computed;
            }
        }
        return result2.current();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable V computeIfAbsent(short key, @NonNull Short2ObjectFunction<? extends V> mappingFunction) {
        Short2ObjectSyncMap.InsertionResult<Object> result2;
        Objects.requireNonNull(mappingFunction, "mappingFunction");
        Short2ObjectSyncMap.ExpungingEntry entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Short2ObjectSyncMap.InsertionResult<V> insertionResult = result2 = entry2 != null ? entry2.computeIfAbsentPrimitive(key, mappingFunction) : null;
        if (result2 != null && result2.operation() == 1) {
            return result2.current();
        }
        Object object = this.lock;
        synchronized (object) {
            entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry2 != null) {
                if (entry2.tryUnexpungeAndComputePrimitive(key, mappingFunction)) {
                    if (entry2.exists()) {
                        this.dirty.put(key, (Short2ObjectSyncMap.ExpungingEntry<Short2ObjectSyncMap.ExpungingEntry>)entry2);
                    }
                    return entry2.get();
                }
                result2 = entry2.computeIfAbsentPrimitive(key, mappingFunction);
            } else if (this.dirty != null && (entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                result2 = entry2.computeIfAbsentPrimitive(key, mappingFunction);
                if (result2.current() == null) {
                    this.dirty.remove(key);
                }
                this.missLocked();
            } else {
                V computed;
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                if ((computed = mappingFunction.get(key)) != null) {
                    this.dirty.put(key, (Short2ObjectSyncMap.ExpungingEntry<ExpungingEntryImpl<V>>)new ExpungingEntryImpl<V>(computed));
                }
                return computed;
            }
        }
        return result2.current();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable V computeIfPresent(short key, @NonNull BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
        Short2ObjectSyncMap.InsertionResult<Object> result2;
        Objects.requireNonNull(remappingFunction, "remappingFunction");
        Short2ObjectSyncMap.ExpungingEntry entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Short2ObjectSyncMap.InsertionResult<V> insertionResult = result2 = entry2 != null ? entry2.computeIfPresent(key, remappingFunction) : null;
        if (result2 != null && result2.operation() == 1) {
            return result2.current();
        }
        Object object = this.lock;
        synchronized (object) {
            entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry2 != null) {
                result2 = entry2.computeIfPresent(key, remappingFunction);
            } else if (this.dirty != null && (entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                result2 = entry2.computeIfPresent(key, remappingFunction);
                if (result2.current() == null) {
                    this.dirty.remove(key);
                }
                this.missLocked();
            }
        }
        return result2 != null ? (V)result2.current() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable V compute(short key, @NonNull BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
        Short2ObjectSyncMap.InsertionResult<Object> result2;
        Objects.requireNonNull(remappingFunction, "remappingFunction");
        Short2ObjectSyncMap.ExpungingEntry entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Short2ObjectSyncMap.InsertionResult<V> insertionResult = result2 = entry2 != null ? entry2.compute(key, remappingFunction) : null;
        if (result2 != null && result2.operation() == 1) {
            return result2.current();
        }
        Object object = this.lock;
        synchronized (object) {
            entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry2 != null) {
                if (entry2.tryUnexpungeAndCompute(key, remappingFunction)) {
                    if (entry2.exists()) {
                        this.dirty.put(key, (Short2ObjectSyncMap.ExpungingEntry<Short2ObjectSyncMap.ExpungingEntry>)entry2);
                    }
                    return entry2.get();
                }
                result2 = entry2.compute(key, remappingFunction);
            } else if (this.dirty != null && (entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                result2 = entry2.compute(key, remappingFunction);
                if (result2.current() == null) {
                    this.dirty.remove(key);
                }
                this.missLocked();
            } else {
                V computed;
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                if ((computed = remappingFunction.apply(key, null)) != null) {
                    this.dirty.put(key, (Short2ObjectSyncMap.ExpungingEntry<ExpungingEntryImpl<V>>)new ExpungingEntryImpl<V>(computed));
                }
                return computed;
            }
        }
        return result2.current();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable V putIfAbsent(short key, @NonNull V value) {
        Short2ObjectSyncMap.InsertionResult<V> result2;
        Objects.requireNonNull(value, "value");
        Short2ObjectSyncMap.ExpungingEntry entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        Short2ObjectSyncMap.InsertionResult<V> insertionResult = result2 = entry2 != null ? entry2.setIfAbsent(value) : null;
        if (result2 != null && result2.operation() == 1) {
            return result2.previous();
        }
        Object object = this.lock;
        synchronized (object) {
            entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry2 != null) {
                if (entry2.tryUnexpungeAndSet(value)) {
                    this.dirty.put(key, (Short2ObjectSyncMap.ExpungingEntry<Short2ObjectSyncMap.ExpungingEntry>)entry2);
                    return null;
                }
                result2 = entry2.setIfAbsent(value);
            } else if (this.dirty != null && (entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                result2 = entry2.setIfAbsent(value);
                this.missLocked();
            } else {
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                this.dirty.put(key, (Short2ObjectSyncMap.ExpungingEntry<ExpungingEntryImpl<V>>)new ExpungingEntryImpl<V>(value));
                return null;
            }
        }
        return result2.previous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable V put(short key, @NonNull V value) {
        V previous;
        Objects.requireNonNull(value, "value");
        Short2ObjectSyncMap.ExpungingEntry entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        V v = previous = entry2 != null ? (V)entry2.get() : null;
        if (entry2 != null && entry2.trySet(value)) {
            return previous;
        }
        Object object = this.lock;
        synchronized (object) {
            entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
            if (entry2 != null) {
                previous = entry2.get();
                if (entry2.tryUnexpungeAndSet(value)) {
                    this.dirty.put(key, (Short2ObjectSyncMap.ExpungingEntry<Short2ObjectSyncMap.ExpungingEntry>)entry2);
                } else {
                    entry2.set(value);
                }
            } else if (this.dirty != null && (entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key)) != null) {
                previous = entry2.get();
                entry2.set(value);
            } else {
                if (!this.amended) {
                    this.dirtyLocked();
                    this.amended = true;
                }
                this.dirty.put(key, (Short2ObjectSyncMap.ExpungingEntry<ExpungingEntryImpl<V>>)new ExpungingEntryImpl<V>(value));
                return null;
            }
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable V remove(short key) {
        Short2ObjectSyncMap.ExpungingEntry entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        if (entry2 == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry2 == null && this.amended && this.dirty != null) {
                    entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.remove(key);
                    this.missLocked();
                }
            }
        }
        return entry2 != null ? (V)entry2.clear() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(short key, @NonNull Object value) {
        Objects.requireNonNull(value, "value");
        Short2ObjectSyncMap.ExpungingEntry entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
        if (entry2 == null && this.amended) {
            Object object = this.lock;
            synchronized (object) {
                entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.read.get(key);
                if (entry2 == null && this.amended && this.dirty != null) {
                    boolean present;
                    entry2 = (Short2ObjectSyncMap.ExpungingEntry)this.dirty.get(key);
                    boolean bl = present = entry2 != null && entry2.replace(value, null);
                    if (present) {
                        this.dirty.remove(key);
                    }
                    this.missLocked();
                    return present;
                }
            }
        }
        return entry2 != null && entry2.replace(value, null);
    }

    @Override
    public @Nullable V replace(short key, @NonNull V value) {
        Objects.requireNonNull(value, "value");
        Short2ObjectSyncMap.ExpungingEntry<V> entry2 = this.getEntry(key);
        return entry2 != null ? (V)entry2.tryReplace(value) : null;
    }

    @Override
    public boolean replace(short key, @NonNull V oldValue, @NonNull V newValue) {
        Objects.requireNonNull(oldValue, "oldValue");
        Objects.requireNonNull(newValue, "newValue");
        Short2ObjectSyncMap.ExpungingEntry<V> entry2 = this.getEntry(key);
        return entry2 != null && entry2.replace(oldValue, newValue);
    }

    @Override
    public void forEach(@NonNull BiConsumer<? super Short, ? super V> action) {
        Objects.requireNonNull(action, "action");
        this.promote();
        for (Short2ObjectMap.Entry entry2 : this.read.short2ObjectEntrySet()) {
            Object value = ((Short2ObjectSyncMap.ExpungingEntry)entry2.getValue()).get();
            if (value == null) continue;
            action.accept(entry2.getShortKey(), value);
        }
    }

    @Override
    public void putAll(@NonNull Map<? extends Short, ? extends V> map2) {
        Objects.requireNonNull(map2, "map");
        for (Map.Entry<Short, V> entry2 : map2.entrySet()) {
            this.put((short)entry2.getKey(), entry2.getValue());
        }
    }

    @Override
    public void replaceAll(@NonNull BiFunction<? super Short, ? super V, ? extends V> function) {
        Objects.requireNonNull(function, "function");
        this.promote();
        for (Short2ObjectMap.Entry entry2 : this.read.short2ObjectEntrySet()) {
            Short2ObjectSyncMap.ExpungingEntry entry22 = (Short2ObjectSyncMap.ExpungingEntry)entry2.getValue();
            Object value = entry22.get();
            if (value == null) continue;
            entry22.tryReplace(function.apply(entry2.getShortKey(), value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.read = this.function.apply(this.read.size());
            this.dirty = null;
            this.amended = false;
            this.misses = 0;
        }
    }

    @Override
    public @NonNull ObjectSet<Short2ObjectMap.Entry<V>> short2ObjectEntrySet() {
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = new EntrySetView();
        return this.entrySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void promote() {
        if (this.amended) {
            Object object = this.lock;
            synchronized (object) {
                if (this.amended) {
                    this.promoteLocked();
                }
            }
        }
    }

    private void missLocked() {
        ++this.misses;
        if (this.misses < this.dirty.size()) {
            return;
        }
        this.promoteLocked();
    }

    private void promoteLocked() {
        this.read = this.dirty;
        this.amended = false;
        this.dirty = null;
        this.misses = 0;
    }

    private void dirtyLocked() {
        if (this.dirty != null) {
            return;
        }
        this.dirty = this.function.apply(this.read.size());
        Short2ObjectMaps.fastForEach(this.read, entry2 -> {
            if (!((Short2ObjectSyncMap.ExpungingEntry)entry2.getValue()).tryExpunge()) {
                this.dirty.put(entry2.getShortKey(), (Short2ObjectSyncMap.ExpungingEntry<Short2ObjectSyncMap.ExpungingEntry>)((Short2ObjectSyncMap.ExpungingEntry)entry2.getValue()));
            }
        });
    }

    final class EntryIterator
    implements ObjectIterator<Short2ObjectMap.Entry<V>> {
        private final Iterator<Short2ObjectMap.Entry<Short2ObjectSyncMap.ExpungingEntry<V>>> backingIterator;
        private Short2ObjectMap.Entry<V> next;
        private Short2ObjectMap.Entry<V> current;

        EntryIterator(Iterator<Short2ObjectMap.Entry<Short2ObjectSyncMap.ExpungingEntry<V>>> backingIterator) {
            this.backingIterator = backingIterator;
            this.advance();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public @NonNull Short2ObjectMap.Entry<V> next() {
            @NonNull Short2ObjectMap.Entry<V> current = this.next;
            if (current == null) {
                throw new NoSuchElementException();
            }
            this.current = current;
            this.advance();
            return current;
        }

        @Override
        public void remove() {
            @NonNull Short2ObjectMap.Entry<V> current = this.current;
            if (current == null) {
                throw new IllegalStateException();
            }
            this.current = null;
            Short2ObjectSyncMapImpl.this.remove(current.getShortKey());
        }

        private void advance() {
            this.next = null;
            while (this.backingIterator.hasNext()) {
                Short2ObjectMap.Entry entry2 = this.backingIterator.next();
                Object value = ((Short2ObjectSyncMap.ExpungingEntry)entry2.getValue()).get();
                if (value == null) continue;
                this.next = new MapEntry(entry2.getShortKey(), value);
                return;
            }
        }
    }

    final class EntrySetView
    extends AbstractObjectSet<Short2ObjectMap.Entry<V>> {
        EntrySetView() {
        }

        @Override
        public int size() {
            return Short2ObjectSyncMapImpl.this.size();
        }

        @Override
        public boolean contains(@Nullable Object entry2) {
            if (!(entry2 instanceof Short2ObjectMap.Entry)) {
                return false;
            }
            Short2ObjectMap.Entry mapEntry = (Short2ObjectMap.Entry)entry2;
            Object value = Short2ObjectSyncMapImpl.this.get(mapEntry.getShortKey());
            return value != null && Objects.equals(value, mapEntry.getValue());
        }

        @Override
        public boolean add(@NonNull Short2ObjectMap.Entry<V> entry2) {
            Objects.requireNonNull(entry2, "entry");
            return Short2ObjectSyncMapImpl.this.put(entry2.getShortKey(), entry2.getValue()) == null;
        }

        @Override
        public boolean remove(@Nullable Object entry2) {
            if (!(entry2 instanceof Short2ObjectMap.Entry)) {
                return false;
            }
            Short2ObjectMap.Entry mapEntry = (Short2ObjectMap.Entry)entry2;
            return Short2ObjectSyncMapImpl.this.remove(mapEntry.getShortKey(), mapEntry.getValue());
        }

        @Override
        public void clear() {
            Short2ObjectSyncMapImpl.this.clear();
        }

        @Override
        public @NonNull ObjectIterator<Short2ObjectMap.Entry<V>> iterator() {
            Short2ObjectSyncMapImpl.this.promote();
            return new EntryIterator(Short2ObjectSyncMapImpl.this.read.short2ObjectEntrySet().iterator());
        }
    }

    final class MapEntry
    implements Short2ObjectMap.Entry<V> {
        private final short key;
        private V value;

        MapEntry(@NonNull short key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public short getShortKey() {
            return this.key;
        }

        @Override
        public @NonNull V getValue() {
            return this.value;
        }

        @Override
        public @Nullable V setValue(@NonNull V value) {
            Objects.requireNonNull(value, "value");
            Object previous = Short2ObjectSyncMapImpl.this.put(this.key, value);
            this.value = value;
            return previous;
        }

        public @NonNull String toString() {
            return "Short2ObjectSyncMapImpl.MapEntry{key=" + this.getShortKey() + ", value=" + this.getValue() + "}";
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Short2ObjectMap.Entry)) {
                return false;
            }
            Short2ObjectMap.Entry that = (Short2ObjectMap.Entry)other;
            return Objects.equals(this.getShortKey(), that.getShortKey()) && Objects.equals(this.getValue(), that.getValue());
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.getShortKey(), this.getValue());
        }
    }

    static final class InsertionResultImpl<V>
    implements Short2ObjectSyncMap.InsertionResult<V> {
        private static final byte UNCHANGED = 0;
        private static final byte UPDATED = 1;
        private static final byte EXPUNGED = 2;
        private final byte operation;
        private final V previous;
        private final V current;

        InsertionResultImpl(byte operation, @Nullable V previous, @Nullable V current) {
            this.operation = operation;
            this.previous = previous;
            this.current = current;
        }

        @Override
        public byte operation() {
            return this.operation;
        }

        @Override
        public @Nullable V previous() {
            return this.previous;
        }

        @Override
        public @Nullable V current() {
            return this.current;
        }
    }

    static final class ExpungingEntryImpl<V>
    implements Short2ObjectSyncMap.ExpungingEntry<V> {
        private static final AtomicReferenceFieldUpdater<ExpungingEntryImpl, Object> UPDATER = AtomicReferenceFieldUpdater.newUpdater(ExpungingEntryImpl.class, Object.class, "value");
        private static final Object EXPUNGED = new Object();
        private volatile Object value;

        ExpungingEntryImpl(@NonNull V value) {
            this.value = value;
        }

        @Override
        public boolean exists() {
            return this.value != null && this.value != EXPUNGED;
        }

        @Override
        public @Nullable V get() {
            return (V)(this.value == EXPUNGED ? null : this.value);
        }

        @Override
        public @NonNull V getOr(@NonNull V other) {
            Object value = this.value;
            return (V)(value != null && value != EXPUNGED ? this.value : other);
        }

        @Override
        public @NonNull Short2ObjectSyncMap.InsertionResult<V> setIfAbsent(@NonNull V value) {
            do {
                Object previous;
                if ((previous = this.value) == EXPUNGED) {
                    return new InsertionResultImpl<Object>(2, null, null);
                }
                if (previous == null) continue;
                return new InsertionResultImpl<Object>(0, previous, previous);
            } while (!UPDATER.compareAndSet(this, null, value));
            return new InsertionResultImpl<Object>(1, null, value);
        }

        @Override
        public @NonNull Short2ObjectSyncMap.InsertionResult<V> computeIfAbsent(short key, @NonNull IntFunction<? extends V> function) {
            Object next = null;
            do {
                Object previous;
                if ((previous = this.value) == EXPUNGED) {
                    return new InsertionResultImpl<Object>(2, null, null);
                }
                if (previous == null) continue;
                return new InsertionResultImpl<Object>(0, previous, previous);
            } while (!UPDATER.compareAndSet(this, null, next != null ? next : (next = (Object)function.apply(key))));
            return new InsertionResultImpl<Object>(1, null, next);
        }

        @Override
        public @NonNull Short2ObjectSyncMap.InsertionResult<V> computeIfAbsentPrimitive(short key, @NonNull Short2ObjectFunction<? extends V> function) {
            Object next = null;
            do {
                Object previous;
                if ((previous = this.value) == EXPUNGED) {
                    return new InsertionResultImpl<Object>(2, null, null);
                }
                if (previous == null) continue;
                return new InsertionResultImpl<Object>(0, previous, previous);
            } while (!UPDATER.compareAndSet(this, null, next != null ? next : (next = function.containsKey(key) ? (Object)function.get(key) : null)));
            return new InsertionResultImpl<Object>(1, null, next);
        }

        @Override
        public @NonNull Short2ObjectSyncMap.InsertionResult<V> computeIfPresent(short key, @NonNull BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
            Object previous;
            Object next = null;
            do {
                if ((previous = this.value) == EXPUNGED) {
                    return new InsertionResultImpl<Object>(2, null, null);
                }
                if (previous != null) continue;
                return new InsertionResultImpl<Object>(0, null, null);
            } while (!UPDATER.compareAndSet(this, previous, next != null ? next : (next = (Object)remappingFunction.apply(key, previous))));
            return new InsertionResultImpl<Object>(1, previous, next);
        }

        @Override
        public @NonNull Short2ObjectSyncMap.InsertionResult<V> compute(short key, @NonNull BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
            Object previous;
            Object next = null;
            do {
                if ((previous = this.value) != EXPUNGED) continue;
                return new InsertionResultImpl<Object>(2, null, null);
            } while (!UPDATER.compareAndSet(this, previous, next != null ? next : (next = (Object)remappingFunction.apply(key, previous))));
            return new InsertionResultImpl<Object>(1, previous, next);
        }

        @Override
        public void set(@NonNull V value) {
            UPDATER.set(this, value);
        }

        @Override
        public boolean replace(@NonNull Object compare, @Nullable V value) {
            Object previous;
            do {
                if ((previous = this.value) != EXPUNGED && Objects.equals(previous, compare)) continue;
                return false;
            } while (!UPDATER.compareAndSet(this, previous, value));
            return true;
        }

        @Override
        public @Nullable V clear() {
            Object previous;
            do {
                if ((previous = this.value) != null && previous != EXPUNGED) continue;
                return null;
            } while (!UPDATER.compareAndSet(this, previous, null));
            return (V)previous;
        }

        @Override
        public boolean trySet(@NonNull V value) {
            Object previous;
            do {
                if ((previous = this.value) != EXPUNGED) continue;
                return false;
            } while (!UPDATER.compareAndSet(this, previous, value));
            return true;
        }

        @Override
        public @Nullable V tryReplace(@NonNull V value) {
            Object previous;
            do {
                if ((previous = this.value) != null && previous != EXPUNGED) continue;
                return null;
            } while (!UPDATER.compareAndSet(this, previous, value));
            return (V)previous;
        }

        @Override
        public boolean tryExpunge() {
            while (this.value == null) {
                if (!UPDATER.compareAndSet(this, null, EXPUNGED)) continue;
                return true;
            }
            return this.value == EXPUNGED;
        }

        @Override
        public boolean tryUnexpungeAndSet(@NonNull V value) {
            return UPDATER.compareAndSet(this, EXPUNGED, value);
        }

        @Override
        public boolean tryUnexpungeAndCompute(short key, @NonNull IntFunction<? extends V> function) {
            if (this.value == EXPUNGED) {
                V value = function.apply(key);
                return UPDATER.compareAndSet(this, EXPUNGED, value);
            }
            return false;
        }

        @Override
        public boolean tryUnexpungeAndComputePrimitive(short key, @NonNull Short2ObjectFunction<? extends V> function) {
            if (this.value == EXPUNGED) {
                Object value = function.containsKey(key) ? (Object)function.get(key) : null;
                return UPDATER.compareAndSet(this, EXPUNGED, value);
            }
            return false;
        }

        @Override
        public boolean tryUnexpungeAndCompute(short key, @NonNull BiFunction<? super Short, ? super V, ? extends V> remappingFunction) {
            if (this.value == EXPUNGED) {
                V value = remappingFunction.apply(key, null);
                return UPDATER.compareAndSet(this, EXPUNGED, value);
            }
            return false;
        }
    }
}

