/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers.raw;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.tinylog.writers.raw.ByteArrayWriter;

public final class RandomAccessFileWriter
implements ByteArrayWriter {
    private final RandomAccessFile file;

    public RandomAccessFileWriter(RandomAccessFile file) {
        this.file = file;
    }

    @Override
    public int readTail(byte[] data2, int offset, int length) throws IOException {
        long fileLength = this.file.length();
        this.file.seek(Math.max(0L, fileLength - (long)length));
        return this.file.read(data2, offset, (int)Math.min(fileLength, (long)length));
    }

    @Override
    public void write(byte[] data2, int length) throws IOException {
        this.write(data2, 0, length);
    }

    @Override
    public void write(byte[] data2, int offset, int length) throws IOException {
        this.file.write(data2, offset, length);
    }

    @Override
    public void truncate(int count2) throws IOException {
        this.file.setLength(Math.max(0L, this.file.length() - (long)count2));
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

