/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers.raw;

import java.io.IOException;
import java.util.Arrays;
import org.tinylog.writers.raw.ByteArrayWriter;

public class CharsetAdjustmentWriterDecorator
implements ByteArrayWriter {
    private final ByteArrayWriter writer;
    private final byte[] charsetHeader;

    public CharsetAdjustmentWriterDecorator(ByteArrayWriter writer, byte[] charsetHeader) {
        this.writer = writer;
        this.charsetHeader = Arrays.copyOf(charsetHeader, charsetHeader.length);
    }

    @Override
    public int readTail(byte[] data2, int offset, int length) throws IOException {
        return this.writer.readTail(data2, offset, length);
    }

    @Override
    public void write(byte[] data2, int length) throws IOException {
        this.write(data2, 0, length);
    }

    @Override
    public void write(byte[] data2, int offset, int length) throws IOException {
        if (this.startsWithCharsetHeader(data2, offset, length)) {
            this.writer.write(data2, offset + this.charsetHeader.length, length - this.charsetHeader.length);
        } else {
            this.writer.write(data2, offset, length);
        }
    }

    @Override
    public void truncate(int count2) throws IOException {
        this.writer.truncate(count2);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private boolean startsWithCharsetHeader(byte[] data2, int offset, int length) {
        if (this.charsetHeader.length > length) {
            return false;
        }
        for (int i = 0; i < this.charsetHeader.length; ++i) {
            if (this.charsetHeader[i] == data2[offset + i]) continue;
            return false;
        }
        return true;
    }
}

