/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers.raw;

import java.io.IOException;
import org.tinylog.writers.raw.ByteArrayWriter;

public final class BufferedWriterDecorator
implements ByteArrayWriter {
    private static final int BUFFER_CAPACITY = 65536;
    private final ByteArrayWriter writer;
    private final byte[] buffer;
    private int position;

    public BufferedWriterDecorator(ByteArrayWriter writer) {
        this.writer = writer;
        this.buffer = new byte[65536];
        this.position = 0;
    }

    @Override
    public int readTail(byte[] data2, int offset, int length) throws IOException {
        if (length <= this.position) {
            System.arraycopy(this.buffer, this.position - length, data2, offset, length);
            return length;
        }
        int readBytes = this.writer.readTail(data2, offset, length - this.position);
        System.arraycopy(this.buffer, 0, data2, offset + readBytes, this.position);
        return readBytes + this.position;
    }

    @Override
    public void write(byte[] data2, int length) throws IOException {
        this.write(data2, 0, length);
    }

    @Override
    public void write(byte[] data2, int offset, int length) throws IOException {
        if (this.position > 0 && 65536 - this.position < length) {
            this.writer.write(this.buffer, 0, this.position);
            this.position = 0;
        }
        if (65536 < length) {
            this.writer.write(data2, offset, length);
        } else {
            System.arraycopy(data2, offset, this.buffer, this.position, length);
            this.position += length;
        }
    }

    @Override
    public void truncate(int count2) throws IOException {
        if (count2 <= this.position) {
            this.position -= count2;
        } else {
            this.writer.truncate(count2 - this.position);
            this.position = 0;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.position > 0) {
            this.writer.write(this.buffer, 0, this.position);
            this.position = 0;
        }
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.position > 0) {
            this.writer.write(this.buffer, 0, this.position);
        }
        this.writer.close();
    }
}

