/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.tinylog.Level;
import org.tinylog.converters.FileConverter;
import org.tinylog.converters.NopFileConverter;
import org.tinylog.core.LogEntry;
import org.tinylog.path.DynamicPath;
import org.tinylog.path.FileTuple;
import org.tinylog.policies.Policy;
import org.tinylog.policies.StartupPolicy;
import org.tinylog.provider.InternalLogger;
import org.tinylog.runtime.RuntimeProvider;
import org.tinylog.writers.AbstractFormatPatternWriter;
import org.tinylog.writers.raw.ByteArrayWriter;

public final class RollingFileWriter
extends AbstractFormatPatternWriter {
    private final DynamicPath path = new DynamicPath(this.getFileName());
    private final List<Policy> policies = RollingFileWriter.createPolicies(this.getStringValue("policies"));
    private final FileConverter converter = RollingFileWriter.createConverter(this.getStringValue("convert"));
    private final int backups;
    private final boolean buffered;
    private final boolean writingThread;
    private final DynamicPath linkToLatest;
    private final Charset charset;
    private ByteArrayWriter writer;

    public RollingFileWriter() throws IOException {
        this(Collections.emptyMap());
    }

    public RollingFileWriter(Map<String, String> properties2) throws IOException {
        super(properties2);
        boolean append;
        String fileName;
        this.backups = properties2.containsKey("backups") ? Integer.parseInt(this.getStringValue("backups")) : -1;
        this.linkToLatest = properties2.containsKey("latest") ? new DynamicPath(this.getStringValue("latest")) : null;
        List<FileTuple> files = this.getAllFileTuplesWithoutLinks(this.converter.getBackupSuffix());
        File latestFile = RollingFileWriter.findLatestLogFile(files);
        if (this.backups >= 0) {
            RollingFileWriter.deleteBackups(files, this.backups);
        }
        if (latestFile != null && this.path.isValid(latestFile)) {
            fileName = latestFile.getAbsolutePath();
            if (RollingFileWriter.canBeContinued(fileName, this.policies)) {
                append = true;
            } else {
                fileName = this.path.resolve();
                append = false;
            }
        } else {
            fileName = this.path.resolve();
            append = false;
        }
        this.charset = this.getCharset();
        this.buffered = this.getBooleanValue("buffered");
        this.writingThread = this.getBooleanValue("writingthread");
        this.writer = this.createByteArrayWriterAndLinkLatest(fileName, append, this.buffered, this.charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(LogEntry logEntry) throws IOException {
        byte[] data2 = this.render(logEntry).getBytes(this.charset);
        if (this.writingThread) {
            this.internalWrite(data2);
        } else {
            ByteArrayWriter byteArrayWriter = this.writer;
            synchronized (byteArrayWriter) {
                this.internalWrite(data2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        if (this.writingThread) {
            this.internalFlush();
        } else {
            ByteArrayWriter byteArrayWriter = this.writer;
            synchronized (byteArrayWriter) {
                this.internalFlush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException, InterruptedException {
        if (this.writingThread) {
            this.internalClose();
        } else {
            ByteArrayWriter byteArrayWriter = this.writer;
            synchronized (byteArrayWriter) {
                this.internalClose();
            }
        }
    }

    private void internalWrite(byte[] data2) throws IOException {
        if (!RollingFileWriter.canBeContinued(data2, this.policies)) {
            this.writer.close();
            this.converter.close();
            String fileName = this.path.resolve();
            this.writer = this.createByteArrayWriterAndLinkLatest(fileName, false, this.buffered, this.charset);
            for (Policy policy : this.policies) {
                policy.reset();
            }
            if (this.backups >= 0) {
                RollingFileWriter.deleteBackups(this.getAllFileTuplesWithoutLinks(this.converter.getBackupSuffix()), this.backups);
            }
        }
        byte[] convertedData = this.converter.write(data2);
        this.writer.write(convertedData, 0, convertedData.length);
    }

    private void internalFlush() throws IOException {
        this.writer.flush();
    }

    private void internalClose() throws IOException, InterruptedException {
        this.writer.close();
        this.converter.close();
        this.converter.shutdown();
    }

    @IgnoreJRERequirement
    private List<FileTuple> getAllFileTuplesWithoutLinks(String backupSuffix) {
        List<FileTuple> files = this.path.getAllFiles(backupSuffix);
        if (this.linkToLatest != null && !RuntimeProvider.isAndroid()) {
            File fileLink = new File(this.linkToLatest.resolve()).getAbsoluteFile();
            Iterator<FileTuple> iterator2 = files.iterator();
            while (iterator2.hasNext()) {
                if (!fileLink.equals(iterator2.next().getOriginal())) continue;
                iterator2.remove();
                break;
            }
        }
        return files;
    }

    @IgnoreJRERequirement
    private ByteArrayWriter createByteArrayWriterAndLinkLatest(String fileName, boolean append, boolean buffered, Charset charset) throws IOException {
        this.converter.open(fileName);
        ByteArrayWriter writer = RollingFileWriter.createByteArrayWriter(fileName, append, buffered, false, false, charset);
        if (this.linkToLatest != null) {
            File logFile = new File(fileName);
            File linkFile = new File(this.linkToLatest.resolve());
            if (!RuntimeProvider.isAndroid()) {
                try {
                    Path logPath = logFile.toPath();
                    Path linkPath = linkFile.toPath();
                    Files.deleteIfExists(linkPath);
                    Files.createLink(linkPath, logPath);
                }
                catch (IOException ex) {
                    InternalLogger.log(Level.ERROR, ex, "Failed to create link '" + linkFile + "'");
                }
            } else {
                InternalLogger.log(Level.WARN, "Cannot create link to latest log file on Android");
            }
        }
        return writer;
    }

    private static File findLatestLogFile(List<FileTuple> files) {
        for (FileTuple file : files) {
            if (!file.getOriginal().isFile() || !file.getOriginal().equals(file.getBackup()) && file.getBackup().isFile()) continue;
            return file.getOriginal();
        }
        return null;
    }

    private static List<Policy> createPolicies(String property) {
        if (property == null || property.isEmpty()) {
            return Collections.singletonList(new StartupPolicy(null));
        }
        if (RuntimeProvider.getProcessId() == Long.MIN_VALUE) {
            ServiceLoader.load(Policy.class);
        }
        return new org.tinylog.configuration.ServiceLoader<Policy>(Policy.class, String.class).createList(property);
    }

    private static FileConverter createConverter(String property) {
        FileConverter converter;
        if (property == null || property.isEmpty()) {
            return new NopFileConverter();
        }
        if (RuntimeProvider.getProcessId() == Long.MIN_VALUE) {
            ServiceLoader.load(FileConverter.class);
        }
        return (converter = new org.tinylog.configuration.ServiceLoader<FileConverter>(FileConverter.class, new Class[0]).create(property, new Object[0])) == null ? new NopFileConverter() : converter;
    }

    private static boolean canBeContinued(String fileName, List<Policy> policies) {
        boolean result2 = true;
        for (Policy policy : policies) {
            result2 &= policy.continueExistingFile(fileName);
        }
        return result2;
    }

    private static boolean canBeContinued(byte[] data2, List<Policy> policies) {
        boolean result2 = true;
        for (Policy policy : policies) {
            result2 &= policy.continueCurrentFile(data2);
        }
        return result2;
    }

    private static void deleteBackups(List<FileTuple> files, int count2) {
        for (int i = count2; i < files.size(); ++i) {
            files.get(i).delete();
        }
    }
}

