/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.writers;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import org.tinylog.Level;
import org.tinylog.provider.InternalLogger;
import org.tinylog.writers.AbstractWriter;
import org.tinylog.writers.raw.BufferedWriterDecorator;
import org.tinylog.writers.raw.ByteArrayWriter;
import org.tinylog.writers.raw.CharsetAdjustmentWriterDecorator;
import org.tinylog.writers.raw.LockedRandomAccessFileWriter;
import org.tinylog.writers.raw.RandomAccessFileWriter;
import org.tinylog.writers.raw.SynchronizedWriterDecorator;

public abstract class AbstractFileBasedWriter
extends AbstractWriter {
    protected AbstractFileBasedWriter(Map<String, String> properties2) {
        super(properties2);
    }

    protected String getFileName() {
        String fileName = this.getStringValue("file");
        if (fileName == null) {
            throw new IllegalArgumentException("File name is missing for writer");
        }
        return fileName;
    }

    protected Charset getCharset() {
        String charsetName = this.getStringValue("charset");
        try {
            return charsetName == null ? Charset.defaultCharset() : Charset.forName(charsetName);
        }
        catch (IllegalArgumentException ex) {
            InternalLogger.log(Level.ERROR, "Invalid charset: " + charsetName);
            return Charset.defaultCharset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ByteArrayWriter createByteArrayWriter(String fileName, boolean append, boolean buffered, boolean threadSafe, boolean shared, Charset charset) throws IOException {
        ByteArrayWriter writer;
        File file = new File(fileName).getAbsoluteFile();
        file.getParentFile().mkdirs();
        byte[] charsetHeader = AbstractFileBasedWriter.getCharsetHeader(charset);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        if (shared) {
            FileLock lock = randomAccessFile.getChannel().lock();
            try {
                AbstractFileBasedWriter.prepareLogFile(randomAccessFile, append, charsetHeader);
            }
            finally {
                lock.release();
            }
            writer = new LockedRandomAccessFileWriter(randomAccessFile);
        } else {
            AbstractFileBasedWriter.prepareLogFile(randomAccessFile, append, charsetHeader);
            writer = new RandomAccessFileWriter(randomAccessFile);
        }
        if (buffered) {
            writer = new BufferedWriterDecorator(writer);
        }
        if (threadSafe) {
            writer = new SynchronizedWriterDecorator(writer, randomAccessFile);
        }
        if (charsetHeader.length > 0) {
            writer = new CharsetAdjustmentWriterDecorator(writer, charsetHeader);
        }
        return writer;
    }

    protected static byte[] getCharsetHeader(Charset charset) {
        byte[] singleSpace = " ".getBytes(charset);
        byte[] doubleSpace = "  ".getBytes(charset);
        return Arrays.copyOf(doubleSpace, singleSpace.length * 2 - doubleSpace.length);
    }

    private static void prepareLogFile(RandomAccessFile randomAccessFile, boolean append, byte[] charsetHeader) throws IOException {
        if (append) {
            randomAccessFile.seek(randomAccessFile.length());
        } else {
            randomAccessFile.setLength(0L);
        }
        if (charsetHeader.length > 0 && randomAccessFile.length() == 0L) {
            randomAccessFile.write(charsetHeader, 0, charsetHeader.length);
        }
    }
}

