/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.slf4j;

import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;
import org.tinylog.Level;
import org.tinylog.format.LegacyMessageFormatter;
import org.tinylog.format.MessageFormatter;
import org.tinylog.provider.LoggingProvider;
import org.tinylog.provider.ProviderRegistry;

public final class TinylogLogger
implements LocationAwareLogger {
    private static final int STACKTRACE_DEPTH = 2;
    private static final MessageFormatter formatter = new LegacyMessageFormatter();
    private static final LoggingProvider provider = ProviderRegistry.getLoggingProvider();
    private static final boolean MINIMUM_GLOBAL_LEVEL_COVERS_TRACE = TinylogLogger.isCoveredByGlobalMinimumLevel(Level.TRACE);
    private static final boolean MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG = TinylogLogger.isCoveredByGlobalMinimumLevel(Level.DEBUG);
    private static final boolean MINIMUM_GLOBAL_LEVEL_COVERS_INFO = TinylogLogger.isCoveredByGlobalMinimumLevel(Level.INFO);
    private static final boolean MINIMUM_GLOBAL_LEVEL_COVERS_WARN = TinylogLogger.isCoveredByGlobalMinimumLevel(Level.WARN);
    private static final boolean MINIMUM_GLOBAL_LEVEL_COVERS_ERROR = TinylogLogger.isCoveredByGlobalMinimumLevel(Level.ERROR);
    private static final boolean MINIMUM_DEFAULT_LEVEL_COVERS_TRACE = TinylogLogger.isCoveredByDefaultMinimumLevel(Level.TRACE);
    private static final boolean MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG = TinylogLogger.isCoveredByDefaultMinimumLevel(Level.DEBUG);
    private static final boolean MINIMUM_DEFAULT_LEVEL_COVERS_INFO = TinylogLogger.isCoveredByDefaultMinimumLevel(Level.INFO);
    private static final boolean MINIMUM_DEFAULT_LEVEL_COVERS_WARN = TinylogLogger.isCoveredByDefaultMinimumLevel(Level.WARN);
    private static final boolean MINIMUM_DEFAULT_LEVEL_COVERS_ERROR = TinylogLogger.isCoveredByDefaultMinimumLevel(Level.ERROR);
    private final String name;

    public TinylogLogger(String name2) {
        this.name = name2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTraceEnabled() {
        return MINIMUM_DEFAULT_LEVEL_COVERS_TRACE && provider.isEnabled(2, null, Level.TRACE);
    }

    @Override
    public void trace(String message) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, null, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public void trace(String format, Object arg) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, TinylogLogger.extractThrowable(arg), formatter, (Object)format, arg);
        }
    }

    @Override
    public void trace(String format, Object arg1, Object arg2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, TinylogLogger.extractThrowable(arg2), formatter, (Object)format, arg1, arg2);
        }
    }

    @Override
    public void trace(String format, Object ... arguments2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, TinylogLogger.extractThrowable(arguments2), formatter, (Object)format, arguments2);
        }
    }

    @Override
    public void trace(String message, Throwable exception) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_TRACE) {
            provider.log(2, null, Level.TRACE, exception, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public boolean isTraceEnabled(Marker marker) {
        String tag = marker == null ? null : marker.getName();
        return MINIMUM_GLOBAL_LEVEL_COVERS_TRACE && provider.isEnabled(2, tag, Level.TRACE);
    }

    @Override
    public void trace(Marker marker, String message) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_TRACE) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.TRACE, null, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_TRACE) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.TRACE, TinylogLogger.extractThrowable(arg), formatter, (Object)format, arg);
        }
    }

    @Override
    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_TRACE) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.TRACE, TinylogLogger.extractThrowable(arg2), formatter, (Object)format, arg1, arg2);
        }
    }

    @Override
    public void trace(Marker marker, String format, Object ... arguments2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_TRACE) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.TRACE, TinylogLogger.extractThrowable(arguments2), formatter, (Object)format, arguments2);
        }
    }

    @Override
    public void trace(Marker marker, String message, Throwable exception) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_TRACE) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.TRACE, exception, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG && provider.isEnabled(2, null, Level.DEBUG);
    }

    @Override
    public void debug(String message) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, null, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public void debug(String format, Object arg) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, TinylogLogger.extractThrowable(arg), formatter, (Object)format, arg);
        }
    }

    @Override
    public void debug(String format, Object arg1, Object arg2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, TinylogLogger.extractThrowable(arg2), formatter, (Object)format, arg1, arg2);
        }
    }

    @Override
    public void debug(String format, Object ... arguments2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, TinylogLogger.extractThrowable(arguments2), formatter, (Object)format, arguments2);
        }
    }

    @Override
    public void debug(String message, Throwable exception) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_DEBUG) {
            provider.log(2, null, Level.DEBUG, exception, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public boolean isDebugEnabled(Marker marker) {
        String tag = marker == null ? null : marker.getName();
        return MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG && provider.isEnabled(2, tag, Level.DEBUG);
    }

    @Override
    public void debug(Marker marker, String message) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.DEBUG, null, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.DEBUG, TinylogLogger.extractThrowable(arg), formatter, (Object)format, arg);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.DEBUG, TinylogLogger.extractThrowable(arg2), formatter, (Object)format, arg1, arg2);
        }
    }

    @Override
    public void debug(Marker marker, String format, Object ... arguments2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.DEBUG, TinylogLogger.extractThrowable(arguments2), formatter, (Object)format, arguments2);
        }
    }

    @Override
    public void debug(Marker marker, String message, Throwable exception) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_DEBUG) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.DEBUG, exception, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public boolean isInfoEnabled() {
        return MINIMUM_DEFAULT_LEVEL_COVERS_INFO && provider.isEnabled(2, null, Level.INFO);
    }

    @Override
    public void info(String message) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, null, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public void info(String format, Object arg) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, TinylogLogger.extractThrowable(arg), formatter, (Object)format, arg);
        }
    }

    @Override
    public void info(String format, Object arg1, Object arg2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, TinylogLogger.extractThrowable(arg2), formatter, (Object)format, arg1, arg2);
        }
    }

    @Override
    public void info(String format, Object ... arguments2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, TinylogLogger.extractThrowable(arguments2), formatter, (Object)format, arguments2);
        }
    }

    @Override
    public void info(String message, Throwable exception) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_INFO) {
            provider.log(2, null, Level.INFO, exception, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public boolean isInfoEnabled(Marker marker) {
        String tag = marker == null ? null : marker.getName();
        return MINIMUM_GLOBAL_LEVEL_COVERS_INFO && provider.isEnabled(2, tag, Level.INFO);
    }

    @Override
    public void info(Marker marker, String message) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_INFO) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.INFO, null, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_INFO) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.INFO, TinylogLogger.extractThrowable(arg), formatter, (Object)format, arg);
        }
    }

    @Override
    public void info(Marker marker, String format, Object arg1, Object arg2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_INFO) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.INFO, TinylogLogger.extractThrowable(arg2), formatter, (Object)format, arg1, arg2);
        }
    }

    @Override
    public void info(Marker marker, String format, Object ... arguments2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_INFO) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.INFO, TinylogLogger.extractThrowable(arguments2), formatter, (Object)format, arguments2);
        }
    }

    @Override
    public void info(Marker marker, String message, Throwable exception) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_INFO) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.INFO, exception, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public boolean isWarnEnabled() {
        return MINIMUM_DEFAULT_LEVEL_COVERS_WARN && provider.isEnabled(2, null, Level.WARN);
    }

    @Override
    public void warn(String message) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, null, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public void warn(String format, Object arg) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, TinylogLogger.extractThrowable(arg), formatter, (Object)format, arg);
        }
    }

    @Override
    public void warn(String format, Object arg1, Object arg2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, TinylogLogger.extractThrowable(arg2), formatter, (Object)format, arg1, arg2);
        }
    }

    @Override
    public void warn(String format, Object ... arguments2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, TinylogLogger.extractThrowable(arguments2), formatter, (Object)format, arguments2);
        }
    }

    @Override
    public void warn(String message, Throwable exception) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_WARN) {
            provider.log(2, null, Level.WARN, exception, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public boolean isWarnEnabled(Marker marker) {
        String tag = marker == null ? null : marker.getName();
        return MINIMUM_GLOBAL_LEVEL_COVERS_WARN && provider.isEnabled(2, tag, Level.WARN);
    }

    @Override
    public void warn(Marker marker, String message) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_WARN) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.WARN, null, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_WARN) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.WARN, TinylogLogger.extractThrowable(arg), formatter, (Object)format, arg);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_WARN) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.WARN, TinylogLogger.extractThrowable(arg2), formatter, (Object)format, arg1, arg2);
        }
    }

    @Override
    public void warn(Marker marker, String format, Object ... arguments2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_WARN) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.WARN, TinylogLogger.extractThrowable(arguments2), formatter, (Object)format, arguments2);
        }
    }

    @Override
    public void warn(Marker marker, String message, Throwable exception) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_WARN) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.WARN, exception, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public boolean isErrorEnabled() {
        return MINIMUM_DEFAULT_LEVEL_COVERS_ERROR && provider.isEnabled(2, null, Level.ERROR);
    }

    @Override
    public void error(String message) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, null, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public void error(String format, Object arg) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, TinylogLogger.extractThrowable(arg), formatter, (Object)format, arg);
        }
    }

    @Override
    public void error(String format, Object arg1, Object arg2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, TinylogLogger.extractThrowable(arg2), formatter, (Object)format, arg1, arg2);
        }
    }

    @Override
    public void error(String format, Object ... arguments2) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, TinylogLogger.extractThrowable(arguments2), formatter, (Object)format, arguments2);
        }
    }

    @Override
    public void error(String message, Throwable exception) {
        if (MINIMUM_DEFAULT_LEVEL_COVERS_ERROR) {
            provider.log(2, null, Level.ERROR, exception, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public boolean isErrorEnabled(Marker marker) {
        String tag = marker == null ? null : marker.getName();
        return MINIMUM_GLOBAL_LEVEL_COVERS_ERROR && provider.isEnabled(2, tag, Level.ERROR);
    }

    @Override
    public void error(Marker marker, String message) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_ERROR) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.ERROR, null, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_ERROR) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.ERROR, TinylogLogger.extractThrowable(arg), formatter, (Object)format, arg);
        }
    }

    @Override
    public void error(Marker marker, String format, Object arg1, Object arg2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_ERROR) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.ERROR, TinylogLogger.extractThrowable(arg2), formatter, (Object)format, arg1, arg2);
        }
    }

    @Override
    public void error(Marker marker, String format, Object ... arguments2) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_ERROR) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.ERROR, TinylogLogger.extractThrowable(arguments2), formatter, (Object)format, arguments2);
        }
    }

    @Override
    public void error(Marker marker, String message, Throwable exception) {
        if (MINIMUM_GLOBAL_LEVEL_COVERS_ERROR) {
            String tag = marker == null ? null : marker.getName();
            provider.log(2, tag, Level.ERROR, exception, null, (Object)message, (Object[])null);
        }
    }

    @Override
    public void log(Marker marker, String fqcn, int level, String message, Object[] arguments2, Throwable exception) {
        String tag;
        Level severityLevel = TinylogLogger.translateLevel(level);
        String string = tag = marker == null ? null : marker.getName();
        if (provider.getMinimumLevel(tag).ordinal() <= severityLevel.ordinal()) {
            provider.log(fqcn, tag, severityLevel, exception, formatter, (Object)message, arguments2);
        }
    }

    private static boolean isCoveredByGlobalMinimumLevel(Level level) {
        return provider.getMinimumLevel().ordinal() <= level.ordinal();
    }

    private static boolean isCoveredByDefaultMinimumLevel(Level level) {
        return provider.getMinimumLevel(null).ordinal() <= level.ordinal();
    }

    private static Level translateLevel(int level) {
        if (level <= 0) {
            return Level.TRACE;
        }
        if (level <= 10) {
            return Level.DEBUG;
        }
        if (level <= 20) {
            return Level.INFO;
        }
        if (level <= 30) {
            return Level.WARN;
        }
        return Level.ERROR;
    }

    private static Throwable extractThrowable(Object[] arguments2) {
        return arguments2.length == 0 ? null : TinylogLogger.extractThrowable(arguments2[arguments2.length - 1]);
    }

    private static Throwable extractThrowable(Object argument) {
        return argument instanceof Throwable ? (Throwable)argument : null;
    }
}

