/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.runtime;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.tinylog.Level;
import org.tinylog.provider.InternalLogger;
import org.tinylog.runtime.AbstractJavaRuntime;
import org.tinylog.runtime.LegacyTimestamp;
import org.tinylog.runtime.LegacyTimestampFormatter;
import org.tinylog.runtime.Timestamp;
import org.tinylog.runtime.TimestampFormatter;
import sun.reflect.Reflection;

public final class LegacyJavaRuntime
extends AbstractJavaRuntime {
    private static final Timestamp startTime = new LegacyTimestamp(ManagementFactory.getRuntimeMXBean().getStartTime());
    private final boolean hasSunReflection = LegacyJavaRuntime.verifySunReflection();
    private final Method stackTraceElementGetter = LegacyJavaRuntime.getStackTraceElementGetter();

    @Override
    public boolean isAndroid() {
        return false;
    }

    @Override
    public long getProcessId() {
        String name2 = ManagementFactory.getRuntimeMXBean().getName();
        try {
            return Long.parseLong(name2.substring(0, name2.indexOf(64)));
        }
        catch (NumberFormatException ex) {
            InternalLogger.log(Level.ERROR, "Illegal process ID: " + name2.substring(0, name2.indexOf(64)));
            return -1L;
        }
        catch (IndexOutOfBoundsException ex) {
            InternalLogger.log(Level.ERROR, "Name of virtual machine does not contain a process ID: " + name2);
            return -1L;
        }
    }

    @Override
    public Timestamp getStartTime() {
        return startTime;
    }

    @Override
    @IgnoreJRERequirement
    public String getCallerClassName(int depth) {
        if (this.hasSunReflection) {
            return Reflection.getCallerClass((int)(depth + 1)).getName();
        }
        return this.getCallerStackTraceElement(depth + 1).getClassName();
    }

    @Override
    public String getCallerClassName(String loggerClassName) {
        StackTraceElement element = this.getCallerStackTraceElement(loggerClassName);
        return element == null ? null : element.getClassName();
    }

    @Override
    public StackTraceElement getCallerStackTraceElement(int depth) {
        if (this.stackTraceElementGetter != null) {
            try {
                return (StackTraceElement)this.stackTraceElementGetter.invoke((Object)new Throwable(), depth);
            }
            catch (IllegalAccessException ex) {
                InternalLogger.log(Level.ERROR, ex, "Failed getting single stack trace element from throwable");
            }
            catch (InvocationTargetException ex) {
                InternalLogger.log(Level.ERROR, ex.getTargetException(), "Failed getting single stack trace element from throwable");
            }
        }
        return new Throwable().getStackTrace()[depth];
    }

    @Override
    public StackTraceElement getCallerStackTraceElement(String loggerClassName) {
        int index;
        StackTraceElement[] trace = new Throwable().getStackTrace();
        for (index = 0; index < trace.length && !loggerClassName.equals(trace[index].getClassName()); ++index) {
        }
        while (index < trace.length && loggerClassName.equals(trace[index].getClassName())) {
            ++index;
        }
        if (index < trace.length) {
            return trace[index];
        }
        return null;
    }

    @Override
    public Timestamp createTimestamp() {
        return new LegacyTimestamp();
    }

    @Override
    public TimestampFormatter createTimestampFormatter(String pattern, Locale locale) {
        return new LegacyTimestampFormatter(pattern, locale);
    }

    @IgnoreJRERequirement
    private static boolean verifySunReflection() {
        try {
            return AbstractJavaRuntime.class.equals((Object)Reflection.getCallerClass((int)1));
        }
        catch (NoClassDefFoundError error) {
            return false;
        }
        catch (NoSuchMethodError error) {
            return false;
        }
        catch (UnsatisfiedLinkError error) {
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static Method getStackTraceElementGetter() {
        try {
            Method method = Throwable.class.getDeclaredMethod("getStackTraceElement", Integer.TYPE);
            method.setAccessible(true);
            StackTraceElement stackTraceElement = (StackTraceElement)method.invoke((Object)new Throwable(), 0);
            if (LegacyJavaRuntime.class.getName().equals(stackTraceElement.getClassName())) {
                return method;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }
}

