/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import org.tinylog.core.LogEntry;
import org.tinylog.core.LogEntryValue;
import org.tinylog.pattern.Token;

final class LoggerTagToken
implements Token {
    private static final String DEFAULT_EMPTY_TAG = "";
    private final String empty;

    LoggerTagToken() {
        this.empty = DEFAULT_EMPTY_TAG;
    }

    LoggerTagToken(String empty2) {
        this.empty = empty2;
    }

    @Override
    public Collection<LogEntryValue> getRequiredLogEntryValues() {
        return Collections.singleton(LogEntryValue.TAG);
    }

    @Override
    public void render(LogEntry logEntry, StringBuilder builder) {
        String tag = logEntry.getTag();
        if (tag == null) {
            builder.append(this.empty);
        } else {
            builder.append(tag);
        }
    }

    @Override
    public void apply(LogEntry logEntry, PreparedStatement statement, int index) throws SQLException {
        String tag = logEntry.getTag();
        if (tag == null) {
            statement.setString(index, DEFAULT_EMPTY_TAG.equals(this.empty) ? null : this.empty);
        } else {
            statement.setString(index, tag);
        }
    }
}

