/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.tinylog.Level;
import org.tinylog.configuration.ServiceLoader;
import org.tinylog.pattern.BundleToken;
import org.tinylog.pattern.DateToken;
import org.tinylog.pattern.ExceptionToken;
import org.tinylog.pattern.FileNameToken;
import org.tinylog.pattern.FullClassNameToken;
import org.tinylog.pattern.IndentationToken;
import org.tinylog.pattern.LineNumberToken;
import org.tinylog.pattern.LoggerTagToken;
import org.tinylog.pattern.MaximumSizeToken;
import org.tinylog.pattern.MessageAndExceptionToken;
import org.tinylog.pattern.MessageToken;
import org.tinylog.pattern.MethodNameToken;
import org.tinylog.pattern.MinimumSizeToken;
import org.tinylog.pattern.PackageNameToken;
import org.tinylog.pattern.PlainTextToken;
import org.tinylog.pattern.ProcessIdToken;
import org.tinylog.pattern.SeverityLevelIntegerToken;
import org.tinylog.pattern.SeverityLevelToken;
import org.tinylog.pattern.SimpleClassNameToken;
import org.tinylog.pattern.SizeToken;
import org.tinylog.pattern.ThreadContextToken;
import org.tinylog.pattern.ThreadIdToken;
import org.tinylog.pattern.ThreadNameToken;
import org.tinylog.pattern.TimestampToken;
import org.tinylog.pattern.Token;
import org.tinylog.pattern.UptimeToken;
import org.tinylog.provider.InternalLogger;
import org.tinylog.throwable.ThrowableFilter;

public final class FormatPatternParser {
    private static final Pattern SPLIT_PATTERN = Pattern.compile(",");
    private final List<ThrowableFilter> filters;

    public FormatPatternParser(String filters) {
        this.filters = filters == null ? Collections.emptyList() : new ServiceLoader<ThrowableFilter>(ThrowableFilter.class, String.class).createList(filters);
    }

    public Token parse(String pattern) {
        int splitIndex;
        ArrayList<Token> tokens = new ArrayList<Token>();
        int start = 0;
        int count2 = 0;
        for (int i = 0; i < pattern.length(); ++i) {
            char character = pattern.charAt(i);
            if (character == '{') {
                if (count2 == 0) {
                    if (start < i) {
                        tokens.add(new PlainTextToken(pattern.substring(start, i)));
                    }
                    start = i;
                }
                ++count2;
                continue;
            }
            if (character != '}') continue;
            if (count2 == 0) {
                InternalLogger.log(Level.ERROR, "Opening curly bracket is missing: '" + pattern + "'");
                continue;
            }
            if (--count2 != 0) continue;
            tokens.add(this.parse(pattern.substring(start + 1, i)));
            start = i + 1;
        }
        if (count2 > 0) {
            InternalLogger.log(Level.ERROR, "Closing curly bracket is missing: '" + pattern + "'");
        }
        if ((splitIndex = pattern.indexOf(124, start)) == -1) {
            tokens.add(this.createPlainToken(pattern.substring(start)));
            return tokens.size() == 1 ? (Token)tokens.get(0) : new BundleToken(tokens);
        }
        String token = pattern.substring(start, splitIndex).trim();
        tokens.add(this.createPlainToken(token));
        String[] styleOptions = SPLIT_PATTERN.split(pattern.substring(splitIndex + 1));
        return FormatPatternParser.styleToken(tokens.size() == 1 ? (Token)tokens.get(0) : new BundleToken(tokens), styleOptions);
    }

    private Token createPlainToken(String placeholder) {
        Token token;
        int splitIndex = placeholder.indexOf(58);
        if (splitIndex == -1) {
            token = this.createPlainToken(placeholder.trim(), null);
        } else {
            String name2 = placeholder.substring(0, splitIndex).trim();
            String configuration = placeholder.substring(splitIndex + 1).trim();
            token = this.createPlainToken(name2, configuration);
        }
        return token == null ? new PlainTextToken(placeholder) : token;
    }

    private Token createPlainToken(String name2, String configuration) {
        if (name2.equals("date")) {
            return FormatPatternParser.createDateToken(configuration);
        }
        if ("timestamp".equals(name2)) {
            return new TimestampToken(configuration);
        }
        if ("uptime".equals(name2)) {
            return configuration == null ? new UptimeToken() : new UptimeToken(configuration);
        }
        if ("pid".equals(name2)) {
            return new ProcessIdToken();
        }
        if ("thread".equals(name2)) {
            return new ThreadNameToken();
        }
        if ("thread-id".equals(name2)) {
            return new ThreadIdToken();
        }
        if ("context".equals(name2)) {
            return FormatPatternParser.createThreadContextToken(configuration);
        }
        if ("class".equals(name2)) {
            return new FullClassNameToken();
        }
        if ("class-name".equals(name2)) {
            return new SimpleClassNameToken();
        }
        if ("package".equals(name2)) {
            return new PackageNameToken();
        }
        if ("method".equals(name2)) {
            return new MethodNameToken();
        }
        if ("file".equals(name2)) {
            return new FileNameToken();
        }
        if ("line".equals(name2)) {
            return new LineNumberToken();
        }
        if ("tag".equals(name2)) {
            return configuration == null ? new LoggerTagToken() : new LoggerTagToken(configuration);
        }
        if ("level".equals(name2)) {
            return new SeverityLevelToken();
        }
        if ("level-code".equals(name2)) {
            return new SeverityLevelIntegerToken();
        }
        if ("message".equals(name2)) {
            return new MessageAndExceptionToken(this.filters);
        }
        if ("message-only".equals(name2)) {
            return new MessageToken();
        }
        if ("exception".equals(name2)) {
            return new ExceptionToken(this.filters);
        }
        if ("opening-curly-bracket".equals(name2)) {
            return new PlainTextToken("{");
        }
        if ("closing-curly-bracket".equals(name2)) {
            return new PlainTextToken("}");
        }
        if ("pipe".equals(name2)) {
            return new PlainTextToken("|");
        }
        return null;
    }

    private static Token createDateToken(String configuration) {
        if (configuration == null) {
            return new DateToken();
        }
        try {
            return new DateToken(configuration);
        }
        catch (IllegalArgumentException ex) {
            InternalLogger.log(Level.ERROR, "'" + configuration + "' is an invalid date format pattern");
            return new DateToken();
        }
    }

    private static Token createThreadContextToken(String configuration) {
        String key;
        if (configuration == null) {
            InternalLogger.log(Level.ERROR, "\"{context}\" requires a key");
            return new PlainTextToken("");
        }
        int splitIndex = configuration.indexOf(44);
        String string = key = splitIndex == -1 ? configuration.trim() : configuration.substring(0, splitIndex).trim();
        if (key.isEmpty()) {
            InternalLogger.log(Level.ERROR, "\"{context}\" requires a key");
            return new PlainTextToken("");
        }
        String defaultValue = splitIndex == -1 ? null : configuration.substring(splitIndex + 1).trim();
        return defaultValue == null ? new ThreadContextToken(key) : new ThreadContextToken(key, defaultValue);
    }

    private static Token styleToken(Token token, String[] options) {
        Token styledToken = token;
        for (String option : options) {
            int number;
            int splitIndex = option.indexOf(61);
            if (splitIndex == -1) {
                InternalLogger.log(Level.ERROR, "No value set for '" + option.trim() + "'");
                continue;
            }
            String key = option.substring(0, splitIndex).trim();
            String value = option.substring(splitIndex + 1).trim();
            try {
                number = FormatPatternParser.parsePositiveInteger(value);
            }
            catch (NumberFormatException ex) {
                InternalLogger.log(Level.ERROR, "'" + value + "' is an invalid value for '" + key + "'");
                continue;
            }
            if ("min-size".equals(key)) {
                styledToken = new MinimumSizeToken(styledToken, number);
                continue;
            }
            if ("max-size".equals(key)) {
                styledToken = new MaximumSizeToken(styledToken, number);
                continue;
            }
            if ("size".equals(key)) {
                styledToken = new SizeToken(styledToken, number);
                continue;
            }
            if ("indent".equals(key)) {
                styledToken = new IndentationToken(styledToken, number);
                continue;
            }
            InternalLogger.log(Level.ERROR, "Unknown style option: '" + key + "'");
        }
        return styledToken;
    }

    private static int parsePositiveInteger(String value) throws NumberFormatException {
        int number = Integer.parseInt(value);
        if (number >= 0) {
            return number;
        }
        throw new NumberFormatException();
    }
}

