/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.path;

import java.io.File;
import org.tinylog.path.Segment;
import org.tinylog.runtime.Timestamp;

final class CountSegment
implements Segment {
    CountSegment() {
    }

    @Override
    public String getStaticText() {
        return null;
    }

    @Override
    public String createToken(String prefix, Timestamp timestamp) {
        String[] entries2;
        String filePrefix;
        File directory;
        int separator = Math.max(prefix.lastIndexOf(File.separatorChar), prefix.lastIndexOf(47));
        if (separator == -1) {
            directory = new File("").getAbsoluteFile();
            filePrefix = prefix;
        } else {
            directory = new File(prefix.substring(0, separator));
            filePrefix = separator == prefix.length() - 1 ? "" : prefix.substring(separator + 1);
        }
        long count2 = 0L;
        if (directory.isDirectory() && (entries2 = directory.list()) != null) {
            for (String entry2 : entries2) {
                Long foundCount;
                if (!entry2.startsWith(filePrefix) || (foundCount = CountSegment.parseDigits(entry2, filePrefix.length())) == null || foundCount + 1L <= count2) continue;
                count2 = foundCount + 1L;
            }
        }
        return Long.toString(count2);
    }

    @Override
    public boolean validateToken(String token) {
        try {
            Long.parseLong(token);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private static Long parseDigits(String text, int start) {
        for (int i = start; i < text.length(); ++i) {
            char character = text.charAt(i);
            if (character >= '0' && character <= '9') continue;
            return CountSegment.parseLong(text.substring(start, i));
        }
        return CountSegment.parseLong(text.substring(start));
    }

    private static Long parseLong(String text) {
        if (text.length() == 0) {
            return null;
        }
        try {
            return Long.parseLong(text);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }
}

