/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.format;

import java.util.IllegalFormatException;
import java.util.Locale;
import org.tinylog.Level;
import org.tinylog.format.AbstractMessageFormatter;
import org.tinylog.provider.InternalLogger;

public class PrintfStyleFormatter
extends AbstractMessageFormatter {
    private final Locale locale;

    public PrintfStyleFormatter(Locale locale) {
        this.locale = locale;
    }

    @Override
    public String format(String message, Object[] arguments2) {
        try {
            return String.format(this.locale, message, PrintfStyleFormatter.resolve(arguments2));
        }
        catch (IllegalFormatException ex) {
            InternalLogger.log(Level.WARN, ex, "Illegal printf format message '" + message + "'");
            return message;
        }
    }
}

