/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.configuration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import org.tinylog.Level;
import org.tinylog.provider.InternalLogger;
import org.tinylog.runtime.RuntimeProvider;

public final class ServiceLoader<T> {
    private static final String SERVICE_PREFIX = "META-INF/services/";
    private static final Pattern SPLIT_PATTERN = Pattern.compile(" ");
    private final Class<? extends T> service;
    private final Class<?>[] argumentTypes;
    private final ClassLoader classLoader;
    private final Collection<String> classes;

    public ServiceLoader(Class<? extends T> service, Class<?> ... argumentTypes) {
        this.service = service;
        this.argumentTypes = argumentTypes;
        String fileName = SERVICE_PREFIX + service.getName();
        for (ClassLoader loader : RuntimeProvider.getClassLoaders()) {
            Enumeration<URL> serviceFiles = ServiceLoader.fetchServiceFiles(loader, fileName);
            if (!serviceFiles.hasMoreElements()) continue;
            this.classLoader = loader;
            this.classes = ServiceLoader.loadClasses(loader, service);
            return;
        }
        this.classLoader = null;
        this.classes = Collections.emptyList();
    }

    public T create(String name2, Object ... arguments2) {
        if (name2.indexOf(46) == -1) {
            String expectingClassName = this.toSimpleClassName(name2);
            for (String className : this.classes) {
                int split = className.lastIndexOf(46);
                String simpleClassName = split == -1 ? className : className.substring(split + 1);
                if (!expectingClassName.equals(simpleClassName)) continue;
                return this.createInstance(className, arguments2);
            }
            InternalLogger.log(Level.ERROR, "Service implementation '" + name2 + "' not found");
            return null;
        }
        return this.createInstance(name2, arguments2);
    }

    public List<T> createList(String list2) {
        ArrayList<T> instances = new ArrayList<T>();
        for (String entry2 : list2.split(",")) {
            T instance;
            if ((entry2 = entry2.trim()).isEmpty()) continue;
            int separator = entry2.indexOf(58);
            if (separator == -1) {
                instance = this.create(entry2, new Object[]{null});
            } else {
                String name2 = entry2.substring(0, separator).trim();
                String argument = entry2.substring(separator + 1).trim();
                instance = this.create(name2, argument);
            }
            if (instance == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    public Collection<T> createAll(Object ... arguments2) {
        ArrayList<T> instances = new ArrayList<T>(this.classes.size());
        for (String className : this.classes) {
            T instance = this.createInstance(className, arguments2);
            if (instance == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    private static Enumeration<URL> fetchServiceFiles(ClassLoader classLoader, String fileName) {
        try {
            return classLoader.getResources(fileName);
        }
        catch (IOException ex) {
            InternalLogger.log(Level.ERROR, "Failed loading services from '" + fileName + "'");
            return Collections.enumeration(Collections.emptyList());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> Collection<String> loadClasses(ClassLoader classLoader, Class<? extends T> service) {
        Enumeration<URL> urls;
        String name2 = SERVICE_PREFIX + service.getName();
        try {
            urls = classLoader.getResources(name2);
        }
        catch (IOException ex) {
            InternalLogger.log(Level.ERROR, "Failed loading services from '" + name2 + "'");
            return Collections.emptyList();
        }
        ArrayList<String> classes2 = new ArrayList<String>();
        while (urls.hasMoreElements()) {
            URL url2 = urls.nextElement();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(url2.openStream(), "utf-8"));
                String line = reader.readLine();
                while (line != null) {
                    if ((line = line.trim()).length() > 0 && line.charAt(0) != '#' && !classes2.contains(line)) {
                        classes2.add(line);
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException ex) {
                InternalLogger.log(Level.ERROR, "Failed reading service resource '" + url2 + "'");
            }
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return classes2;
    }

    public String toSimpleClassName(String name2) {
        StringBuilder builder = new StringBuilder(name2.length());
        for (String token : SPLIT_PATTERN.split(name2)) {
            if (token.isEmpty()) continue;
            builder.append(Character.toUpperCase(token.charAt(0)));
            builder.append(token.substring(1).toLowerCase(Locale.ROOT));
        }
        builder.append(this.service.getSimpleName());
        return builder.toString();
    }

    private T createInstance(String className, Object ... arguments2) {
        try {
            Class<?> implementation = Class.forName(className, false, this.classLoader);
            if (this.service.isAssignableFrom(implementation)) {
                return (T)implementation.getDeclaredConstructor(this.argumentTypes).newInstance(arguments2);
            }
            InternalLogger.log(Level.ERROR, "Class '" + className + "' does not implement service interface '" + this.service + "'");
        }
        catch (ClassNotFoundException ex) {
            InternalLogger.log(Level.ERROR, "Service implementation '" + className + "' not found");
        }
        catch (NoSuchMethodException ex) {
            InternalLogger.log(Level.ERROR, "Service implementation '" + className + "' has no matching constructor");
        }
        catch (InstantiationException ex) {
            InternalLogger.log(Level.ERROR, "Service implementation '" + className + "' is not instantiable");
        }
        catch (IllegalAccessException ex) {
            InternalLogger.log(Level.ERROR, "Constructor of service implementation '" + className + "' is not accessible");
        }
        catch (IllegalArgumentException ex) {
            InternalLogger.log(Level.ERROR, "Illegal arguments for constructor of service implementation '" + className + "'");
        }
        catch (InvocationTargetException ex) {
            InternalLogger.log(Level.ERROR, ex.getTargetException(), "Failed creating service implementation '" + className + "'");
        }
        return null;
    }
}

