/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite;

import java.sql.SQLException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.sqlite.core.DB;

public class ExtendedCommand {
    public static SQLExtension parse(String sql2) throws SQLException {
        if (sql2 == null) {
            return null;
        }
        if (sql2.length() > 5 && sql2.substring(0, 6).toLowerCase().equals("backup")) {
            return BackupCommand.parse(sql2);
        }
        if (sql2.length() > 6 && sql2.substring(0, 7).toLowerCase().equals("restore")) {
            return RestoreCommand.parse(sql2);
        }
        return null;
    }

    public static String removeQuotation(String s2) {
        if (s2 == null) {
            return s2;
        }
        if (s2.startsWith("\"") && s2.endsWith("\"") || s2.startsWith("'") && s2.endsWith("'")) {
            return s2.substring(1, s2.length() - 1);
        }
        return s2;
    }

    public static class RestoreCommand
    implements SQLExtension {
        public final String targetDB;
        public final String srcFile;
        private static Pattern restoreCmd = Pattern.compile("restore(\\s+(\"[^\"]*\"|'[^']*'|\\S+))?\\s+from\\s+(\"[^\"]*\"|'[^']*'|\\S+)", 2);

        public RestoreCommand(String targetDB, String srcFile) {
            this.targetDB = targetDB;
            this.srcFile = srcFile;
        }

        public static RestoreCommand parse(String sql2) throws SQLException {
            Matcher m4;
            if (sql2 != null && (m4 = restoreCmd.matcher(sql2)).matches()) {
                String dbName = ExtendedCommand.removeQuotation(m4.group(2));
                String dest = ExtendedCommand.removeQuotation(m4.group(3));
                if (dbName == null || dbName.length() == 0) {
                    dbName = "main";
                }
                return new RestoreCommand(dbName, dest);
            }
            throw new SQLException("syntax error: " + sql2);
        }

        @Override
        public void execute(DB db) throws SQLException {
            db.restore(this.targetDB, this.srcFile, null);
        }
    }

    public static class BackupCommand
    implements SQLExtension {
        public final String srcDB;
        public final String destFile;
        private static Pattern backupCmd = Pattern.compile("backup(\\s+(\"[^\"]*\"|'[^']*'|\\S+))?\\s+to\\s+(\"[^\"]*\"|'[^']*'|\\S+)", 2);

        public BackupCommand(String srcDB, String destFile) {
            this.srcDB = srcDB;
            this.destFile = destFile;
        }

        public static BackupCommand parse(String sql2) throws SQLException {
            Matcher m4;
            if (sql2 != null && (m4 = backupCmd.matcher(sql2)).matches()) {
                String dbName = ExtendedCommand.removeQuotation(m4.group(2));
                String dest = ExtendedCommand.removeQuotation(m4.group(3));
                if (dbName == null || dbName.length() == 0) {
                    dbName = "main";
                }
                return new BackupCommand(dbName, dest);
            }
            throw new SQLException("syntax error: " + sql2);
        }

        @Override
        public void execute(DB db) throws SQLException {
            db.backup(this.srcDB, this.destFile, null);
        }
    }

    public static interface SQLExtension {
        public void execute(DB var1) throws SQLException;
    }
}

