/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.plexus.components.cipher;

import java.security.Provider;
import java.security.Security;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.sonatype.plexus.components.cipher.PBECipher;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;

public class DefaultPlexusCipher
extends AbstractLogEnabled
implements PlexusCipher {
    private static final Pattern ENCRYPTED_STRING_PATTERN = Pattern.compile(".*?[^\\\\]?\\{(.*?[^\\\\])\\}.*");
    private final PBECipher _cipher = new PBECipher();

    public String encrypt(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        return this._cipher.encrypt64(str, passPhrase);
    }

    public String encryptAndDecorate(String str, String passPhrase) throws PlexusCipherException {
        return this.decorate(this.encrypt(str, passPhrase));
    }

    public String decrypt(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        return this._cipher.decrypt64(str, passPhrase);
    }

    public String decryptDecorated(String str, String passPhrase) throws PlexusCipherException {
        if (str == null || str.length() < 1) {
            return str;
        }
        if (this.isEncryptedString(str)) {
            return this.decrypt(this.unDecorate(str), passPhrase);
        }
        return this.decrypt(str, passPhrase);
    }

    public boolean isEncryptedString(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(str);
        return matcher.matches() || matcher.find();
    }

    public String unDecorate(String str) throws PlexusCipherException {
        Matcher matcher = ENCRYPTED_STRING_PATTERN.matcher(str);
        if (matcher.matches() || matcher.find()) {
            return matcher.group(1);
        }
        throw new PlexusCipherException("default.plexus.cipher.badEncryptedPassword");
    }

    public String decorate(String str) {
        return '{' + (str == null ? "" : str) + '}';
    }

    public static String[] getServiceTypes() {
        HashSet<String> result2 = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys2 = providers[i].keySet();
            Iterator<Object> it = keys2.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if ((key = key.split(" ")[0]).startsWith("Alg.Alias.")) {
                    key = key.substring(10);
                }
                int ix = key.indexOf(46);
                result2.add(key.substring(0, ix));
            }
        }
        return result2.toArray(new String[result2.size()]);
    }

    public static String[] getCryptoImpls(String serviceType) {
        HashSet<String> result2 = new HashSet<String>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Set<Object> keys2 = providers[i].keySet();
            Iterator<Object> it = keys2.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                if ((key = key.split(" ")[0]).startsWith(serviceType + ".")) {
                    result2.add(key.substring(serviceType.length() + 1));
                    continue;
                }
                if (!key.startsWith("Alg.Alias." + serviceType + ".")) continue;
                result2.add(key.substring(serviceType.length() + 11));
            }
        }
        return result2.toArray(new String[result2.size()]);
    }

    public static void main(String[] args2) {
        String[] serviceTypes = DefaultPlexusCipher.getServiceTypes();
        if (serviceTypes != null) {
            for (int i = 0; i < serviceTypes.length; ++i) {
                String serviceType = serviceTypes[i];
                String[] serviceProviders = DefaultPlexusCipher.getCryptoImpls(serviceType);
                if (serviceProviders != null) {
                    System.out.println(serviceType + ": provider list");
                    for (int j = 0; j < serviceProviders.length; ++j) {
                        String provider = serviceProviders[j];
                        System.out.println("        " + provider);
                    }
                    continue;
                }
                System.out.println(serviceType + ": does not have any providers in this environment");
            }
        }
    }
}

