/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.helpers;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.helpers.BasicMarker;

public class BasicMarkerFactory
implements IMarkerFactory {
    private final ConcurrentMap<String, Marker> markerMap = new ConcurrentHashMap<String, Marker>();

    @Override
    public Marker getMarker(String name2) {
        Marker oldMarker;
        if (name2 == null) {
            throw new IllegalArgumentException("Marker name cannot be null");
        }
        Marker marker = (Marker)this.markerMap.get(name2);
        if (marker == null && (oldMarker = this.markerMap.putIfAbsent(name2, marker = new BasicMarker(name2))) != null) {
            marker = oldMarker;
        }
        return marker;
    }

    @Override
    public boolean exists(String name2) {
        if (name2 == null) {
            return false;
        }
        return this.markerMap.containsKey(name2);
    }

    @Override
    public boolean detachMarker(String name2) {
        if (name2 == null) {
            return false;
        }
        return this.markerMap.remove(name2) != null;
    }

    @Override
    public Marker getDetachedMarker(String name2) {
        return new BasicMarker(name2);
    }
}

