/*
 * Decompiled with CFR 0.152.
 */
package org.jline.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.Objects;
import org.jline.utils.Log;

public final class Signals {
    private Signals() {
    }

    public static Object register(String name2, Runnable handler) {
        Objects.requireNonNull(handler);
        return Signals.register(name2, handler, handler.getClass().getClassLoader());
    }

    public static Object register(String name2, Runnable handler, ClassLoader loader) {
        try {
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            Object signalHandler = Proxy.newProxyInstance(loader, new Class[]{signalHandlerClass}, (proxy, method, args2) -> {
                if (method.getDeclaringClass() == Object.class) {
                    if ("toString".equals(method.getName())) {
                        return handler.toString();
                    }
                } else if (method.getDeclaringClass() == signalHandlerClass) {
                    Log.trace(() -> "Calling handler " + Signals.toString(handler) + " for signal " + name2);
                    handler.run();
                }
                return null;
            });
            return Signals.doRegister(name2, signalHandler);
        }
        catch (Exception e) {
            Log.debug("Error registering handler for signal ", name2, e);
            return null;
        }
    }

    public static Object registerDefault(String name2) {
        try {
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            return Signals.doRegister(name2, signalHandlerClass.getField("SIG_DFL").get(null));
        }
        catch (Exception e) {
            Log.debug("Error registering default handler for signal ", name2, e);
            return null;
        }
    }

    public static void unregister(String name2, Object previous) {
        try {
            if (previous != null) {
                Signals.doRegister(name2, previous);
            }
        }
        catch (Exception e) {
            Log.debug("Error unregistering handler for signal ", name2, e);
        }
    }

    private static Object doRegister(String name2, Object handler) throws Exception {
        Object signal;
        Log.trace(() -> "Registering signal " + name2 + " with handler " + Signals.toString(handler));
        Class<?> signalClass = Class.forName("sun.misc.Signal");
        Constructor<?> constructor = signalClass.getConstructor(String.class);
        try {
            signal = constructor.newInstance(name2);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof IllegalArgumentException) {
                Log.trace(() -> "Ignoring unsupported signal " + name2);
            } else {
                Log.debug("Error registering handler for signal ", name2, e);
            }
            return null;
        }
        Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
        return signalClass.getMethod("handle", signalClass, signalHandlerClass).invoke(null, signal, handler);
    }

    private static String toString(Object handler) {
        try {
            Class<?> signalHandlerClass = Class.forName("sun.misc.SignalHandler");
            if (handler == signalHandlerClass.getField("SIG_DFL").get(null)) {
                return "SIG_DFL";
            }
            if (handler == signalHandlerClass.getField("SIG_IGN").get(null)) {
                return "SIG_IGN";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return handler != null ? handler.toString() : "null";
    }
}

