/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jline.builtins.ConsoleOptionGetter;
import org.jline.utils.StyleResolver;

public class Styles {
    protected static final List<String> ANSI_STYLES = Arrays.asList("blink", "bold", "conceal", "crossed-out", "crossedout", "faint", "hidden", "inverse", "inverse-neg", "inverseneg", "italic", "underline");
    private static final String DEFAULT_LS_COLORS = "di=1;91:ex=1;92:ln=1;96:fi=";
    private static final String DEFAULT_HELP_COLORS = "ti=1;34:co=1:ar=3:op=33";
    private static final String DEFAULT_PRNT_COLORS = "th=1;34:rn=1;34:rs=,~grey15:mk=1;34:em=31:vs=32";
    private static final String LS_COLORS = "LS_COLORS";
    private static final String HELP_COLORS = "HELP_COLORS";
    private static final String PRNT_COLORS = "PRNT_COLORS";
    private static final String KEY = "([a-z]{2}|\\*\\.[a-zA-Z0-9]+)";
    private static final String VALUE = "([!~#]?[a-zA-Z0-9]+[a-z0-9-;]*)?";
    private static final String VALUES = "([!~#]?[a-zA-Z0-9]+[a-z0-9-;]*)?(,([!~#]?[a-zA-Z0-9]+[a-z0-9-;]*)?)*";
    private static final String STYLE_PATTERN = "([a-z]{2}|\\*\\.[a-zA-Z0-9]+)=([!~#]?[a-zA-Z0-9]+[a-z0-9-;]*)?(,([!~#]?[a-zA-Z0-9]+[a-z0-9-;]*)?)*(:([a-z]{2}|\\*\\.[a-zA-Z0-9]+)=([!~#]?[a-zA-Z0-9]+[a-z0-9-;]*)?(,([!~#]?[a-zA-Z0-9]+[a-z0-9-;]*)?)*)*(:|)";

    public static StyleResolver lsStyle() {
        return Styles.style(LS_COLORS, DEFAULT_LS_COLORS);
    }

    public static StyleResolver helpStyle() {
        return Styles.style(HELP_COLORS, DEFAULT_HELP_COLORS);
    }

    public static StyleResolver prntStyle() {
        return Styles.style(PRNT_COLORS, DEFAULT_PRNT_COLORS);
    }

    public static boolean isStylePattern(String style) {
        return style.matches(STYLE_PATTERN);
    }

    private static StyleResolver style(String name2, String defStyle) {
        String style = Styles.consoleOption(name2);
        if (style == null) {
            style = defStyle;
        }
        return Styles.style(style);
    }

    private static String consoleOption(String name2) {
        String out = null;
        try {
            ConsoleOptionGetter cog = (ConsoleOptionGetter)Class.forName("org.jline.console.SystemRegistry").getDeclaredMethod("get", new Class[0]).invoke(null, new Object[0]);
            if (cog != null && (out = (String)cog.consoleOption(name2)) != null && !out.matches(STYLE_PATTERN)) {
                out = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (out == null && (out = System.getenv(name2)) != null && !out.matches(STYLE_PATTERN)) {
            out = null;
        }
        return out;
    }

    public static StyleResolver style(String style) {
        Map<String, String> colors = Arrays.stream(style.split(":")).collect(Collectors.toMap(s2 -> s2.substring(0, s2.indexOf(61)), s2 -> s2.substring(s2.indexOf(61) + 1)));
        return new StyleResolver(new StyleCompiler(colors)::getStyle);
    }

    protected static class StyleCompiler {
        private static final String ANSI_VALUE = "[0-9]*(;[0-9]+){0,2}";
        private static final String COLORS_24BIT = "[#x][0-9a-fA-F]{6}";
        private static final List<String> COLORS_8 = Arrays.asList("white", "black", "red", "blue", "green", "yellow", "magenta", "cyan");
        private static final Map<String, Integer> COLORS_NANO = new HashMap<String, Integer>();
        private final Map<String, String> colors;
        private final boolean nanoStyle;

        public StyleCompiler(Map<String, String> colors) {
            this(colors, false);
        }

        public StyleCompiler(Map<String, String> colors, boolean nanoStyle) {
            this.colors = colors;
            this.nanoStyle = nanoStyle;
        }

        public String getStyle(String reference) {
            if (!this.colors.containsKey(reference)) {
                return null;
            }
            String rawStyle = this.colors.get(reference);
            if (!this.nanoStyle && rawStyle.matches(ANSI_VALUE)) {
                return rawStyle;
            }
            StringBuilder out = new StringBuilder();
            boolean first2 = true;
            boolean fg = true;
            for (String s2 : rawStyle.split(",")) {
                if (s2.trim().isEmpty()) {
                    fg = false;
                    continue;
                }
                if (!first2) {
                    out.append(",");
                }
                if (ANSI_STYLES.contains(s2)) {
                    out.append(s2);
                } else if (COLORS_8.contains(s2) || COLORS_NANO.containsKey(s2) || s2.startsWith("light") || s2.startsWith("bright") || s2.startsWith("~") || s2.startsWith("!") || s2.matches("\\d+") || s2.matches(COLORS_24BIT) || s2.equals("normal") || s2.equals("default")) {
                    if (s2.matches(COLORS_24BIT)) {
                        if (fg) {
                            out.append("fg-rgb:");
                        } else {
                            out.append("bg-rgb:");
                        }
                        out.append(s2);
                    } else if (s2.matches("\\d+") || COLORS_NANO.containsKey(s2)) {
                        if (fg) {
                            out.append("38;5;");
                        } else {
                            out.append("48;5;");
                        }
                        out.append(s2.matches("\\d+") ? s2 : COLORS_NANO.get(s2).toString());
                    } else {
                        if (fg) {
                            out.append("fg:");
                        } else {
                            out.append("bg:");
                        }
                        if (COLORS_8.contains(s2) || s2.startsWith("~") || s2.startsWith("!") || s2.startsWith("bright-")) {
                            out.append(s2);
                        } else if (s2.startsWith("light")) {
                            out.append("!").append(s2.substring(5));
                        } else if (s2.startsWith("bright")) {
                            out.append("!").append(s2.substring(6));
                        } else {
                            out.append("default");
                        }
                    }
                    fg = false;
                }
                first2 = false;
            }
            return out.toString();
        }

        static {
            COLORS_NANO.put("pink", 204);
            COLORS_NANO.put("purple", 163);
            COLORS_NANO.put("mauve", 134);
            COLORS_NANO.put("lagoon", 38);
            COLORS_NANO.put("mint", 48);
            COLORS_NANO.put("lime", 148);
            COLORS_NANO.put("peach", 215);
            COLORS_NANO.put("orange", 208);
            COLORS_NANO.put("latte", 137);
        }
    }
}

