/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.nbt.mutable;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.collections.ImmutableByteArray;
import org.jglrxavpok.hephaistos.collections.ImmutableIntArray;
import org.jglrxavpok.hephaistos.collections.ImmutableLongArray;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTByte;
import org.jglrxavpok.hephaistos.nbt.NBTByteArray;
import org.jglrxavpok.hephaistos.nbt.NBTCompound;
import org.jglrxavpok.hephaistos.nbt.NBTCompoundLike;
import org.jglrxavpok.hephaistos.nbt.NBTDouble;
import org.jglrxavpok.hephaistos.nbt.NBTFloat;
import org.jglrxavpok.hephaistos.nbt.NBTInt;
import org.jglrxavpok.hephaistos.nbt.NBTIntArray;
import org.jglrxavpok.hephaistos.nbt.NBTList;
import org.jglrxavpok.hephaistos.nbt.NBTLong;
import org.jglrxavpok.hephaistos.nbt.NBTLongArray;
import org.jglrxavpok.hephaistos.nbt.NBTShort;
import org.jglrxavpok.hephaistos.nbt.NBTString;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010)\n\u0002\u0010'\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\n\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u001d\b\u0007\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u000bH\u0016J\u0006\u0010\f\u001a\u00020\rJ\u001a\u0010\u000e\u001a\u00020\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u000bJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0096\u0002J\u001c\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001f\u0010\u001a\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u001cj\u0002`\u001d0\u001bH\u0096\u0002J\u0011\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0001H\u0096\u0002J\u001d\u0010\u001f\u001a\u00020\r2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0!H\u0086\u0002J\u001d\u0010\u001f\u001a\u00020\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u000bH\u0086\u0002J\u0011\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0001H\u0086\u0002J\u0018\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\bJ\u001a\u0010$\u001a\u00020\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u000bJ\u000e\u0010$\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0001J\u0010\u0010%\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0007J\u0016\u0010%\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\bJ\u0019\u0010&\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\bH\u0086\u0002J\u001a\u0010'\u001a\u00020\u00002\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u000bJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0001J\u0016\u0010(\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u00020)J\u0016\u0010*\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u00020+J\u0016\u0010*\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u00020,J\u0016\u0010-\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u00020.J\u0016\u0010/\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u000200J\u0016\u00101\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0019J\u0016\u00102\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u000203J\u0016\u00102\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u000204J\u0016\u00105\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u000206J\u0016\u00107\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u000208J\u0016\u00107\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u000209J\u0016\u0010:\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u00020;J\u0016\u0010<\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007J\b\u0010=\u001a\u00020\u0003H\u0016J\b\u0010>\u001a\u00020\u0000H\u0016J\b\u0010?\u001a\u00020\u0007H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/mutable/MutableNBTCompound;", "Lorg/jglrxavpok/hephaistos/nbt/NBTCompoundLike;", "nbt", "Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;", "(Lorg/jglrxavpok/hephaistos/nbt/NBTCompound;)V", "tags", "", "", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "(Ljava/util/Map;)V", "asMapView", "", "clear", "", "copyFrom", "from", "equals", "", "other", "", "getOrPut", "key", "defaultValue", "Lkotlin/Function0;", "hashCode", "", "iterator", "", "", "Lorg/jglrxavpok/hephaistos/nbt/MutableCompoundEntry;", "plus", "plusAssign", "p", "Lkotlin/Pair;", "put", "value", "putAll", "remove", "set", "setAll", "setByte", "", "setByteArray", "", "Lorg/jglrxavpok/hephaistos/collections/ImmutableByteArray;", "setDouble", "", "setFloat", "", "setInt", "setIntArray", "", "Lorg/jglrxavpok/hephaistos/collections/ImmutableIntArray;", "setLong", "", "setLongArray", "", "Lorg/jglrxavpok/hephaistos/collections/ImmutableLongArray;", "setShort", "", "setString", "toCompound", "toMutableCompound", "toString", "common"})
public final class MutableNBTCompound
implements NBTCompoundLike {
    @NotNull
    private final Map<String, NBT> tags;

    @JvmOverloads
    public MutableNBTCompound(@NotNull Map<String, NBT> tags) {
        Intrinsics.checkNotNullParameter(tags, "tags");
        this.tags = tags;
    }

    public /* synthetic */ MutableNBTCompound(Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            boolean bl = false;
            map2 = new LinkedHashMap();
        }
        this(map2);
    }

    public MutableNBTCompound(@NotNull NBTCompound nbt) {
        Intrinsics.checkNotNullParameter(nbt, "nbt");
        this(MapsKt.toMutableMap(nbt.asMapView()));
    }

    @Override
    @NotNull
    public NBTCompound toCompound() {
        return NBT.Companion.Compound(MapsKt.toMap(this.tags));
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof NBTCompoundLike)) {
            return false;
        }
        return Intrinsics.areEqual(this.tags, ((NBTCompoundLike)other).asMapView());
    }

    public int hashCode() {
        return ((Object)this.tags).hashCode();
    }

    @NotNull
    public String toString() {
        return this.toSNBT();
    }

    @NotNull
    public final MutableNBTCompound set(@NotNull String key, @NotNull NBT value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        Map<String, NBT> map2 = this.tags;
        boolean bl = false;
        map2.put(key, value);
        return this;
    }

    @NotNull
    public final MutableNBTCompound setByte(@NotNull String key, byte value) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.set(key, new NBTByte(value));
    }

    @NotNull
    public final MutableNBTCompound setByteArray(@NotNull String key, @NotNull ImmutableByteArray value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        return this.set(key, new NBTByteArray(value));
    }

    @NotNull
    public final MutableNBTCompound setByteArray(@NotNull String key, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        return this.set(key, new NBTByteArray(Arrays.copyOf(value, value.length)));
    }

    @NotNull
    public final MutableNBTCompound setDouble(@NotNull String key, double value) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.set(key, new NBTDouble(value));
    }

    @NotNull
    public final MutableNBTCompound setFloat(@NotNull String key, float value) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.set(key, new NBTFloat(value));
    }

    @NotNull
    public final MutableNBTCompound setInt(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.set(key, new NBTInt(value));
    }

    @NotNull
    public final MutableNBTCompound setIntArray(@NotNull String key, @NotNull ImmutableIntArray value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        return this.set(key, new NBTIntArray(value));
    }

    @NotNull
    public final MutableNBTCompound setIntArray(@NotNull String key, @NotNull int[] value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        return this.set(key, new NBTIntArray(Arrays.copyOf(value, value.length)));
    }

    @NotNull
    public final MutableNBTCompound setLong(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.set(key, new NBTLong(value));
    }

    @NotNull
    public final MutableNBTCompound setLongArray(@NotNull String key, @NotNull ImmutableLongArray value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        return this.set(key, new NBTLongArray(value));
    }

    @NotNull
    public final MutableNBTCompound setLongArray(@NotNull String key, @NotNull long[] value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        return this.set(key, new NBTLongArray(Arrays.copyOf(value, value.length)));
    }

    @NotNull
    public final MutableNBTCompound setShort(@NotNull String key, short value) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.set(key, new NBTShort(value));
    }

    @NotNull
    public final MutableNBTCompound setString(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        return this.set(key, new NBTString(value));
    }

    @Override
    @NotNull
    public Map<String, NBT> asMapView() {
        return this.tags;
    }

    @Override
    @NotNull
    public MutableNBTCompound toMutableCompound() {
        return new MutableNBTCompound((Map<String, NBT>)new HashMap<String, NBT>(this.tags));
    }

    public final void clear() {
        this.tags.clear();
    }

    @Nullable
    public final NBT put(@NotNull String key, @NotNull NBT value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        return this.tags.put(key, value);
    }

    @NotNull
    public final MutableNBTCompound putAll(@NotNull Map<String, ? extends NBT> from) {
        Intrinsics.checkNotNullParameter(from, "from");
        Object object = from;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends NBT>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object2 = object = iterator2.next();
            boolean bl2 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            NBT value = (NBT)object3.getValue();
            this.set(key, value);
        }
        return this;
    }

    @NotNull
    public final MutableNBTCompound putAll(@NotNull NBTCompoundLike from) {
        Intrinsics.checkNotNullParameter(from, "from");
        return this.putAll(from.asMapView());
    }

    @NotNull
    public final MutableNBTCompound setAll(@NotNull Map<String, ? extends NBT> from) {
        Intrinsics.checkNotNullParameter(from, "from");
        return this.putAll(from);
    }

    @NotNull
    public final MutableNBTCompound setAll(@NotNull NBTCompoundLike from) {
        Intrinsics.checkNotNullParameter(from, "from");
        return this.putAll(from);
    }

    public final void plusAssign(@NotNull Map<String, ? extends NBT> other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.putAll(other);
    }

    public final void plusAssign(@NotNull NBTCompoundLike other) {
        Intrinsics.checkNotNullParameter(other, "other");
        this.plusAssign(other.asMapView());
    }

    public final void plusAssign(@NotNull Pair<String, ? extends NBT> p) {
        Intrinsics.checkNotNullParameter(p, "p");
        MutableNBTCompound mutableNBTCompound = this;
        Map<String, NBT> map2 = mutableNBTCompound.tags;
        boolean bl = false;
        map2.put(p.getFirst(), p.getSecond());
    }

    @Override
    @NotNull
    public MutableNBTCompound plus(@NotNull NBTCompoundLike other) {
        Intrinsics.checkNotNullParameter(other, "other");
        MutableNBTCompound mutable = new MutableNBTCompound(MapsKt.toMutableMap(this.tags));
        mutable.plusAssign(other);
        return mutable;
    }

    @NotNull
    public final MutableNBTCompound copyFrom(@NotNull Map<String, ? extends NBT> from) {
        Intrinsics.checkNotNullParameter(from, "from");
        this.clear();
        return this.setAll(from);
    }

    @NotNull
    public final MutableNBTCompound copyFrom(@NotNull NBTCompoundLike from) {
        Intrinsics.checkNotNullParameter(from, "from");
        this.clear();
        return this.setAll(from);
    }

    @Nullable
    public final NBT remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter(key, "key");
        return this.tags.remove(key);
    }

    public final boolean remove(@NotNull String key, @NotNull NBT value) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(value, "value");
        return this.tags.remove(key, value);
    }

    @NotNull
    public final NBT getOrPut(@NotNull String key, @NotNull Function0<? extends NBT> defaultValue) {
        NBT nBT;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(defaultValue, "defaultValue");
        Map<String, NBT> $this$getOrPut$iv = this.tags;
        boolean $i$f$getOrPut = false;
        NBT value$iv = $this$getOrPut$iv.get(key);
        if (value$iv == null) {
            NBT answer$iv = defaultValue.invoke();
            $this$getOrPut$iv.put(key, answer$iv);
            nBT = answer$iv;
        } else {
            nBT = value$iv;
        }
        return nBT;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<String, NBT>> iterator() {
        Map<String, NBT> map2 = this.tags;
        boolean bl = false;
        return map2.entrySet().iterator();
    }

    @Override
    @Nullable
    public <T extends NBT> NBTList<T> getList(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getList(this, key);
    }

    @Override
    public boolean contains(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.contains(this, key);
    }

    @Override
    public boolean containsKey(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.containsKey(this, key);
    }

    @Override
    public boolean containsValue(@NotNull NBT value) {
        return NBTCompoundLike.DefaultImpls.containsValue(this, value);
    }

    @Override
    public void forEach(@NotNull Function1<? super Map.Entry<String, ? extends NBT>, Unit> action) {
        NBTCompoundLike.DefaultImpls.forEach((NBTCompoundLike)this, action);
    }

    @Override
    public void forEach(@NotNull BiConsumer<String, NBT> action) {
        NBTCompoundLike.DefaultImpls.forEach((NBTCompoundLike)this, action);
    }

    @Override
    @Nullable
    public NBT get(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.get(this, key);
    }

    @Override
    @Nullable
    public Byte getAsByte(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getAsByte(this, key);
    }

    @Override
    @Nullable
    public Double getAsDouble(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getAsDouble(this, key);
    }

    @Override
    @Nullable
    public Float getAsFloat(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getAsFloat(this, key);
    }

    @Override
    @Nullable
    public Integer getAsInt(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getAsInt(this, key);
    }

    @Override
    @Nullable
    public Long getAsLong(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getAsLong(this, key);
    }

    @Override
    @Nullable
    public Short getAsShort(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getAsShort(this, key);
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getBoolean(this, key);
    }

    @Override
    @Nullable
    public Byte getByte(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getByte(this, key);
    }

    @Override
    @Nullable
    public ImmutableByteArray getByteArray(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getByteArray(this, key);
    }

    @Override
    @Nullable
    public NBTCompound getCompound(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getCompound(this, key);
    }

    @Override
    @Nullable
    public Double getDouble(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getDouble(this, key);
    }

    @Override
    @Nullable
    public Float getFloat(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getFloat(this, key);
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getInt(this, key);
    }

    @Override
    @Nullable
    public ImmutableIntArray getIntArray(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getIntArray(this, key);
    }

    @Override
    @Nullable
    public Long getLong(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getLong(this, key);
    }

    @Override
    @Nullable
    public ImmutableLongArray getLongArray(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getLongArray(this, key);
    }

    @Override
    @Nullable
    public Number getNumber(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getNumber(this, key);
    }

    @Override
    @NotNull
    public NBT getOrElse(@NotNull String key, @NotNull NBT defaultValue) {
        return NBTCompoundLike.DefaultImpls.getOrElse(this, key, defaultValue);
    }

    @Override
    @Nullable
    public Short getShort(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getShort(this, key);
    }

    @Override
    @Nullable
    public String getString(@NotNull String key) {
        return NBTCompoundLike.DefaultImpls.getString(this, key);
    }

    @Override
    public boolean isEmpty() {
        return NBTCompoundLike.DefaultImpls.isEmpty(this);
    }

    @Override
    @NotNull
    public String toSNBT() {
        return NBTCompoundLike.DefaultImpls.toSNBT(this);
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, NBT>> getEntries() {
        return NBTCompoundLike.DefaultImpls.getEntries(this);
    }

    @Override
    @NotNull
    public Set<String> getKeys() {
        return NBTCompoundLike.DefaultImpls.getKeys(this);
    }

    @Override
    public int getSize() {
        return NBTCompoundLike.DefaultImpls.getSize(this);
    }

    @Override
    @NotNull
    public Collection<NBT> getValues() {
        return NBTCompoundLike.DefaultImpls.getValues(this);
    }

    @JvmOverloads
    public MutableNBTCompound() {
        this(null, 1, null);
    }
}

