/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.nbt;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jglrxavpok.hephaistos.nbt.CompressedProcesser;
import org.jglrxavpok.hephaistos.nbt.ExtensionsKt;
import org.jglrxavpok.hephaistos.nbt.NBT;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B!\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007B!\b\u0017\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\nB!\b\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/NBTWriter;", "Ljava/lang/AutoCloseable;", "Ljava/io/Closeable;", "file", "Ljava/io/File;", "compressedProcesser", "Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;", "(Ljava/io/File;Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;)V", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;)V", "destination", "Ljava/io/OutputStream;", "(Ljava/io/OutputStream;Lorg/jglrxavpok/hephaistos/nbt/CompressedProcesser;)V", "writer", "Ljava/io/DataOutputStream;", "close", "", "writeNamed", "name", "", "tag", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "writeRaw", "common"})
public final class NBTWriter
implements AutoCloseable,
Closeable {
    @NotNull
    private final DataOutputStream writer;

    @JvmOverloads
    public NBTWriter(@NotNull OutputStream destination, @NotNull CompressedProcesser<?, ?> compressedProcesser) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        Intrinsics.checkNotNullParameter(compressedProcesser, "compressedProcesser");
        this.writer = new DataOutputStream(compressedProcesser.generateOutputStream(destination));
    }

    public /* synthetic */ NBTWriter(OutputStream outputStream, CompressedProcesser compressedProcesser, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            compressedProcesser = CompressedProcesser.GZIP;
        }
        this(outputStream, compressedProcesser);
    }

    @JvmOverloads
    public NBTWriter(@NotNull File file, @NotNull CompressedProcesser<?, ?> compressedProcesser) throws IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        Intrinsics.checkNotNullParameter(compressedProcesser, "compressedProcesser");
        this(new BufferedOutputStream(new FileOutputStream(file)), compressedProcesser);
    }

    public /* synthetic */ NBTWriter(File file, CompressedProcesser compressedProcesser, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 2) != 0) {
            compressedProcesser = CompressedProcesser.GZIP;
        }
        this(file, compressedProcesser);
    }

    @JvmOverloads
    public NBTWriter(@NotNull Path path, @NotNull CompressedProcesser<?, ?> compressedProcesser) throws IOException {
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(compressedProcesser, "compressedProcesser");
        this(new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0])), compressedProcesser);
    }

    public /* synthetic */ NBTWriter(Path path, CompressedProcesser compressedProcesser, int n, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n & 2) != 0) {
            compressedProcesser = CompressedProcesser.GZIP;
        }
        this(path, compressedProcesser);
    }

    public final void writeNamed(@NotNull String name2, @NotNull NBT tag) throws IOException {
        Intrinsics.checkNotNullParameter(name2, "name");
        Intrinsics.checkNotNullParameter(tag, "tag");
        ExtensionsKt.writeFullyFormedTag(this.writer, name2, tag);
    }

    public final void writeRaw(@NotNull NBT tag) throws IOException {
        Intrinsics.checkNotNullParameter(tag, "tag");
        tag.writeContents(this.writer);
    }

    @Override
    public void close() {
        this.writer.close();
    }

    @JvmOverloads
    public NBTWriter(@NotNull OutputStream destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        this(destination, null, 2, null);
    }

    @JvmOverloads
    public NBTWriter(@NotNull File file) throws IOException {
        Intrinsics.checkNotNullParameter(file, "file");
        this(file, null, 2, null);
    }

    @JvmOverloads
    public NBTWriter(@NotNull Path path) throws IOException {
        Intrinsics.checkNotNullParameter(path, "path");
        this(path, null, 2, null);
    }
}

