/*
 * Decompiled with CFR 0.152.
 */
package org.jglrxavpok.hephaistos.nbt;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jglrxavpok.hephaistos.nbt.NBT;
import org.jglrxavpok.hephaistos.nbt.NBTReaderCompanion;
import org.jglrxavpok.hephaistos.nbt.NBTType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0003H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00000\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/NBTString;", "Lorg/jglrxavpok/hephaistos/nbt/NBT;", "value", "", "(Ljava/lang/String;)V", "ID", "Lorg/jglrxavpok/hephaistos/nbt/NBTType;", "getID", "()Lorg/jglrxavpok/hephaistos/nbt/NBTType;", "getValue", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "toSNBT", "toString", "writeContents", "", "destination", "Ljava/io/DataOutputStream;", "Companion", "common"})
public final class NBTString
implements NBT {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;
    @NotNull
    private final NBTType<NBTString> ID;

    public NBTString(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.value = value;
        this.ID = NBTType.TAG_String;
    }

    @Override
    @NotNull
    public String getValue() {
        return this.value;
    }

    @NotNull
    public NBTType<NBTString> getID() {
        return this.ID;
    }

    @Override
    public void writeContents(@NotNull DataOutputStream destination) {
        Intrinsics.checkNotNullParameter(destination, "destination");
        destination.writeUTF(this.getValue());
    }

    @Override
    @NotNull
    public String toSNBT() {
        String escaped = StringsKt.replace$default(this.getValue(), "\"", "\\\"", false, 4, null);
        return '\"' + escaped + '\"';
    }

    @Override
    @NotNull
    public String toString() {
        return this.toSNBT();
    }

    public boolean equals(@Nullable Object other) {
        Object object;
        if (this == other) {
            return true;
        }
        if (!Intrinsics.areEqual(this.getClass(), (object = other) == null ? null : object.getClass())) {
            return false;
        }
        if (other == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jglrxavpok.hephaistos.nbt.NBTString");
        }
        NBTString cfr_ignored_0 = (NBTString)other;
        return Intrinsics.areEqual(this.getValue(), ((NBTString)other).getValue());
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getValue()};
        return Objects.hash(objectArray);
    }

    @Override
    @NotNull
    public byte[] toByteArray() throws IOException {
        return NBT.DefaultImpls.toByteArray(this);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lorg/jglrxavpok/hephaistos/nbt/NBTString$Companion;", "Lorg/jglrxavpok/hephaistos/nbt/NBTReaderCompanion;", "Lorg/jglrxavpok/hephaistos/nbt/NBTString;", "()V", "readContents", "source", "Ljava/io/DataInputStream;", "common"})
    public static final class Companion
    implements NBTReaderCompanion<NBTString> {
        private Companion() {
        }

        @Override
        @NotNull
        public NBTString readContents(@NotNull DataInputStream source) {
            Intrinsics.checkNotNullParameter(source, "source");
            String string = source.readUTF();
            Intrinsics.checkNotNullExpressionValue(string, "source.readUTF()");
            return new NBTString(string);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

